from sandbox import sdk2
from sandbox import common

from sandbox.common.types.misc import NotExists
import sandbox.common.types.task as ctt
from sandbox.projects import DeployNannyDashboard as deploy_nanny_dashboard
from sandbox.projects.collections.resources import CollectionsFeedBanTrie


class CollectionsDeployFeedBanTrie(sdk2.Task):
    """ Task for feed ban trie deployment """

    class Parameters(sdk2.Task.Parameters):
        ban_trie_resource = sdk2.parameters.Resource(
            "Resource with feed ban trie",
            resource_type=CollectionsFeedBanTrie,
            required=True
        )
        nanny_token_vault = sdk2.parameters.String('Nanny oauth token vault name', required=True)
        nanny_token_owner = sdk2.parameters.String('Nanny oauth token vault owner', required=True)

    def release_ban_trie_task(self):
        self.server.release(
            task_id=self.Parameters.ban_trie_resource.task_id,
            type=ctt.ReleaseStatus.STABLE,
            subject='Feed ban trie autodeploy from sandbox task {}'.format(self.id)
        )

    def run_dashboard_task(self):
        deploy_task_params = {
            'deployment_nanny_dashboard_name': 'pdb_production',
            'deployment_nanny_dashboard_recipe': 'deploy_hotfeed_reader_service_by_locations_without_closing_locations',
            'deployment_nanny_dashboard_filter': 'feed_reader',
            'deployment_task_id': self.Parameters.ban_trie_resource.task_id,
            'deployment_release_status': 'stable',
            'vault_name': self.Parameters.nanny_token_vault,
            'vault_owner': self.Parameters.nanny_token_owner,
            'deployment_nanny_bool_wait': True,
        }
        deploy_task = sdk2.Task[deploy_nanny_dashboard.DeployNannyDashboard.type](
            self,
            description='Run production deployment.',
            **deploy_task_params
        )
        deploy_task.save().enqueue()
        self.Context.deploy_task_id = deploy_task.id
        self.Context.save()
        raise sdk2.WaitTask(
            [self.Context.deploy_task_id],
            ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
            wait_all=True
        )

    def deploy(self):
        self.release_ban_trie_task()
        self.run_dashboard_task()

    def check_deploy_task(self):
        child = sdk2.Task[self.Context.deploy_task_id]
        if child.status != ctt.Status.SUCCESS:
            raise common.errors.TaskFailure('Deploy task has finished with status {}'.format(child.status))

    def on_execute(self):
        with self.memoize_stage.deploy:
            self.deploy()

        with self.memoize_stage.check_deploy:
            self.check_deploy_task()
