from sandbox import sdk2

from sandbox.projects.collections.master_item_recommender.components import MasterItemRecommender
from sandbox.projects.collections.recommender_base.GeneralTest import GeneralTestBase
from sandbox.projects.collections.resources import CollectionsMasterItemRecommenderBundle

import os


class MasterItemRecommenderGeneralTest(GeneralTestBase):
    """ Task for testing base Master Item Recommender functionality """

    class Requirements(GeneralTestBase.DefaultRequirements):
        ram = 4 * 1024
        disk_space = 8 * 1024

    class Parameters(GeneralTestBase.DefaultParameters):
        bundle_resource = sdk2.parameters.Resource(
            "Resource with Master Item Recommender bundle",
            resource_type=CollectionsMasterItemRecommenderBundle,
            required=True
        )
        env_mongo_pdb_token = sdk2.parameters.String('MONGO_PDB vault', required=True)
        env_mongo_pdb_cg_token = sdk2.parameters.String('MONGO_PDB_CG vault', required=True)
        env_ydb_token = sdk2.parameters.String('YDB_TOKEN vault', required=True)

    def on_execute(self):
        env = os.environ.copy()
        env["MONGO_PDB"] = sdk2.Vault.data(self.Parameters.env_mongo_pdb_token)
        env["MONGO_PDB_CG"] = sdk2.Vault.data(self.Parameters.env_mongo_pdb_cg_token)
        env["YDB_TOKEN"] = sdk2.Vault.data(self.Parameters.env_ydb_token)

        bundle_resource_data = sdk2.ResourceData(self.Parameters.bundle_resource)
        self.__execute__(MasterItemRecommender(self, env, str(bundle_resource_data.path), self.Parameters.port))
