from sandbox import sdk2
from sandbox.sandboxsdk.network import is_port_free

from sandbox.sdk2.helpers import subprocess as sp

import os
import shutil
import tarfile
import time


class MasterItemRecommender:
    def __init__(self, task, env_variables, bundle_path, port):
        with tarfile.open(bundle_path, "r:gz") as tar:
            tar.extractall()

        for file_name in os.listdir("./resources"):
            shutil.copy(
                os.path.join("./resources", file_name),
                os.path.join(".", file_name))


        self.process_log = sdk2.helpers.ProcessLog(task, logger="master_item_recommender.log")
        self.process = sp.Popen(
            [
                "./master_item_recommender",
                "--config", "config.pbtxt",
                "--port", str(port),
            ],
            stdout=self.process_log.stdout, stderr=sp.STDOUT, env=env_variables
        )
        while is_port_free(port):
            time.sleep(1)
            poll_result = self.process.poll()
            if poll_result is not None:
                raise RuntimeError("Error in Master Item Recommender starting. Return code = {}".format(poll_result))

    def close(self):
        self.process.terminate()
