import os

from sandbox.projects.collections.recommender import resources
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build import parameters


class CollectionsRecommenderBuildBinaries(YaMakeTask):
    type = 'COLLECTIONS_RECOMMENDER_BUILD_BINARIES'

    TARGET_RESOURCE_TYPES = [
        resources.CollectionsRecommender,
        resources.CollectionsRecommenderViewer
    ]

    input_parameters = [
        parameters.ArcadiaUrl,
        parameters.ArcadiaPatch,
        parameters.BuildSystem,
        parameters.BuildType,
    ]

    def get_targets(self):
        return [os.path.dirname(resource_type.arcadia_build_path) for resource_type in self.TARGET_RESOURCE_TYPES]

    def get_resources(self):
        resources = {}
        for resource_type in self.TARGET_RESOURCE_TYPES:
            resource = {
                'description': resource_type.name,
                'resource_type': resource_type,
                'resource_path': os.path.basename(resource_type.arcadia_build_path)
            }
            resources[resource_type.name] = resource

        return resources

    def get_arts(self):
        return [{'path': resource_type.arcadia_build_path} for resource_type in self.TARGET_RESOURCE_TYPES]


__Task__ = CollectionsRecommenderBuildBinaries
