from sandbox.projects.collections.resources import CollectionsResourceBase


class CollectionsRecommender(CollectionsResourceBase):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = "yweb/yasap/pdb/quality/recommender/runtime"


class CollectionsRecommenderViewer(CollectionsResourceBase):
    releasable = True
    any_arch = False
    executable = True
    arcadia_build_path = "yweb/yasap/pdb/quality/recommender/viewer"


class CollectionsRecommenderShardBase(CollectionsResourceBase):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class CollectionsRecommenderShardmapBase(CollectionsResourceBase):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shardmap = True


class CollectionsRecommenderShardBoards(CollectionsRecommenderShardBase): pass


class CollectionsRecommenderShardmapBoards(CollectionsRecommenderShardmapBase): pass
