import logging
import os
import tarfile

from sandbox import common
from sandbox import sdk2

from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.svn import Arcadia
import sandbox.common.types.task as ctt

class BuildModelsArchiveBase(nanny.ReleaseToNannyTask2, sdk2.Task):
    """ Base task for building models archive"""

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True)
        models_dir_path = sdk2.parameters.String("SVN dir with models", required=True)

    def __execute__(self, resource):
        models_dir_path = "./models"
        Arcadia.export(self.Parameters.models_dir_path + "@" + str(self.Parameters.svn_revision), models_dir_path)

        resource_data = sdk2.ResourceData(resource)

        tar = tarfile.open(str(resource_data.path), 'w:gz')
        for f in os.listdir(models_dir_path):
            tar.add(os.path.join(models_dir_path, f), arcname=f)
        tar.close()

        resource_data.ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
