from sandbox import sdk2

from sandbox.projects import resource_types
from sandbox.projects.common import dolbilka

import sandbox.common.types.client as ctc


class GeneralTestBase(sdk2.Task):
    """ Task for testing base service functionality """

    class DefaultRequirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC & ctc.Tag.Group.LINUX

    class DefaultParameters(sdk2.Task.Parameters):
        port = sdk2.parameters.Integer("Port", default=15358, required=True)
        request_count = sdk2.parameters.Integer("Count of requests", default=100000, required=True)
        dolbilka_plan_resource = sdk2.parameters.Resource(
            "Resource with dolbilka plan",
            resource_type=resource_types.BASESEARCH_PLAN,
            required=True
        )
        max_simultaneous_requests = sdk2.parameters.Integer(
            "Max simultaneous requests",
            default=4,
            required=True)

    def __execute__(self, service):
        dolbilka_plan_resource_data = sdk2.ResourceData(self.Parameters.dolbilka_plan_resource)
        d_executor = dolbilka.DolbilkaExecutor()
        d_executor.mode = dolbilka.DolbilkaExecutorMode.PLAN_MODE
        d_executor.requests = self.Parameters.request_count
        d_executor.max_simultaneous_requests = self.Parameters.max_simultaneous_requests
        d_executor.mode = dolbilka.DolbilkaExecutorMode.FINGER_MODE

        dump_path = "./results.dump"
        d_executor.run_session(str(dolbilka_plan_resource_data.path),
                               dump_path,
                               port=self.Parameters.port)
        parsed_stat = d_executor.run_dumper(dump_path, "Test results")
        result_stat = d_executor.dumper.get_results(dump_path)

        count_of_5xx_str = d_executor.dumper.find_parameter_in_dolbilka_stat(
            result_stat, "Internal server error(.*)")
        count_of_5xx = 0 if count_of_5xx_str is None else int(count_of_5xx_str)
        service_unavailable = 0 if parsed_stat["service_unavailable"] is None else\
            int(parsed_stat["service_unavailable"])

        if int(parsed_stat["error_requests"]) > 0 or service_unavailable > 0 or count_of_5xx > 0:
            raise RuntimeError("There are some errors in request processing.")

        service.close()
