from sandbox.projects import resource_types

from sandbox import sdk2

from sandbox.projects.collections.recommender_base.shooting_task2 import ShootingTask2

from sandbox.projects.common import dolbilka2
from sandbox.projects.tank import executor2 as tank_executor2


class PerfTestBase(sdk2.Task, ShootingTask2):
    """ Base task for testing base performance """

    class DefaultParameters(sdk2.Task.Parameters):
        port = sdk2.parameters.Integer("Port for service", default=15358, required=True)
        request_count = sdk2.parameters.Integer("Count of requests", default=100000, required=True)
        dolbilka_plan_resource = sdk2.parameters.Resource(
            "Resource with dolbilka plan",
            resource_type=resource_types.BASESEARCH_PLAN,
            required=True
        )
        exp_name = sdk2.parameters.String(
            "Experiment name",
            required=False
        )
        dolbilka_param = dolbilka2.DolbilkaExecutor2.Parameters
        lunapark_param = tank_executor2.LunaparkPlugin.Parameters
        offline_param = tank_executor2.OfflinePlugin.Parameters


    class DefaultRequirements(sdk2.Task.Requirements):
        client_tags = ShootingTask2.client_tags
        cores = 4


    def __execute__(self, service):
        self._init_virtualenv()
        augment_url = None
        if self.Parameters.exp_name is not None and len(self.Parameters.exp_name) > 0:
            augment_url = "&exp_name={}".format(self.Parameters.exp_name)
        self._dolbilo_shoot(self.Parameters.port, self.Parameters.dolbilka_plan_resource, "perf_test", augment_url)

        service.close()

    @sdk2.footer()
    def footer(self):
        return ShootingTask2.footer(self)
