from sandbox import sdk2

from sandbox.common.types.misc import NotExists
from sandbox.projects.tank.load_resources import resources as tank_resources
from sandbox.projects.tank import executor2 as tank_executor

import sandbox.common.types.client as ctc

import os
import six.moves.urllib as urllib


class ShootingTask2:
    new_stats_key = "new_stats"

    new_stats_types = (
        ("shooting.rps_0.5", "RPS P50", "{:0.2f}"),
        ("shooting.rps_stddev", "RPS stddev", "{:0.2f}"),
        ("shooting.latency_0.5", "Latency P50", "{:0.2f}"),
        ("shooting.latency_0.99", "Latency P99", "{:0.2f}"),
        ("shooting.errors", "Errors", "{}"),
        ("monitoring.cpu_user", "CPU P50", "{:0.2f}"),
    )

    client_tags = ctc.Tag.GENERIC & ctc.Tag.LINUX_PRECISE & ctc.Tag.INTEL_E5_2650

    @sdk2.footer()
    def footer(self):
        if getattr(self.Context, self.new_stats_key) is NotExists:
            return "Calculating..."

        stats = getattr(self.Context, self.new_stats_key)

        body = ""
        for key, title, fmt in self.new_stats_types:
            body += "<tr><td style=\"border: 1px; border-style: solid\">{}</td><td style=\"border: 1px; border-style: solid\">{}</td></tr>".format(key, self._format_stats(fmt, stats, key))

        return "<h3>Performance stats</h3><table style=\"border: 1px; border-collapse: collapse; border-style: solid\">{}</table>".format(body)

    def _format_stats(self, fmt, stats, key):
        return fmt.format(stats[key])

    def _shoot(self, executor, variant, autostop_expected=False):
        description = "{}, basesearch {}".format(self.Parameters.description, variant)

        stats_dir = "fire.{}".format(urllib.parse.quote(variant, safe=""))
        stats_resource = sdk2.Resource[tank_resources.YANDEX_TANK_LOGS](self, description, stats_dir)
        stats_resource_data = sdk2.ResourceData(stats_resource)
        stats_resource_data.path.mkdir(0o755, parents=True, exist_ok=True)
        work_dir = str(stats_resource_data.path)

        # Note: cgroup is too restrictive to obtain maximum possible rps
        artifacts_dir = executor.fire(
            work_dir,
            job_name=description,
            cgroup=None,
            autostop_expected=autostop_expected,
        )
        return stats_resource, artifacts_dir

    def _dolbilo_shoot(self, port, plan_resource, variant, augment_url=None):
        stats_resource, artifacts_dir = self._shoot(
            tank_executor.TankExecutor2(
                tank_executor.DolbiloPlugin(self, plan_resource, "localhost", port, augment_url=augment_url),
                *self._default_plugins()
            ),
            variant
        )

        # new stats
        new_stats_results = tank_executor.DolbiloPlugin.get_stats(artifacts_dir)
        new_stats_results.update({
            "report_resource": stats_resource.id,
            "report_path": os.path.relpath(tank_executor.TankExecutor2.get_report_path(artifacts_dir), str(stats_resource.path)),
        })

        lunapark_url = tank_executor.LunaparkPlugin.get_job_url(self)
        if lunapark_url:
            new_stats_results["report_url"] = lunapark_url

        if getattr(self.Context, self.new_stats_key) is NotExists:
            setattr(self.Context, self.new_stats_key, new_stats_results)

    def _default_plugins(self):
        return [
            tank_executor.JsonReportPlugin(self),
            tank_executor.LunaparkPlugin(self),
            tank_executor.TelegrafPlugin(self),
            tank_executor.OfflinePlugin(self)
        ]

    def _init_virtualenv(self, tank_resource_type=tank_resources.YANDEX_TANK_VIRTUALENV_19):
        tank_executor.TankExecutor2.init_virtualenv(self, tank_resource_type=tank_resource_type)
