import os

from sandbox import sdk2

PATH_TO_PODB_DIR = 'yweb/yasap/pdb'
PATH_TO_PODB_BACKEND_BIN = os.path.join(PATH_TO_PODB_DIR, 'pdb-backend/bin')


class CollectionsResourceBase(sdk2.Resource):
    releasers = [
        "teleport",
        "ftdebugger",
        "menjoy",
        "next0",
        "ssamsonov",
        "yseredich",
        "volodskikh",
        "jisuto",
        "kcd",
        "v01d",
        "alexbudanov",
        "nexidan",
        "semyonmo",
        "proskurnev",
        "kasperovich",
        "dobrowin",
        "s-chabarov",
        "panovav",
        "dan-chir",
        "alekseyzotov",
        "pogodina-eval",
        "tocher",
        "anton-bely",
        "aetat",
        "mfurzikov",
        "klimanso",
        "dmitriy96",
        "ayevttukh",
        "rocketraccoon",
        "dshmatkov",
        "shashkin",
        "vkorbut",
        "goldfarb",
        "anoh",
        "asntr",
        "babashev",
        "volia-29",
        "a-aidyn00",
        "liams",
        "gyroscope",
        "abakharev",
        "nbahob",
        "thenno",
        "sersmirnov",
        "cvzakhar",
        "spkhaykova",
        "kigan",
        "platosha",
        "nick-kar",
        "yurikiselev",
        "yushiryaeva",
        "my34",
        "dedcannibal",
        "skosheev",
        "dpoponkin",
        # robots
        "robot-collections",
        "robot-pdb-builder",
        "robot-frontend",
        "robot-trendbot",
        # other robots
        "robot-testenv",
        "robot-srch-releaser",
    ]


class CollectionsMongodbDump(CollectionsResourceBase):
    """
        Package with encrypted mongodb dumps
    """
    any_arch = False
    auto_backup = True


class CollectionsDumpConverter(CollectionsResourceBase):
    """
        Collections' tool for converting mongodump into yt json
    """
    any_arch = False
    auto_backup = True
    releasable = True


class PdbMongodb(CollectionsResourceBase):
    """
        folder with mongodb static utils
    """
    any_arch = False
    executable = False
    auto_backup = True
    releasable = True


class CollectionsMongoLog(CollectionsResourceBase):
    """
        File with mongo logs
    """
    any_arch = False
    auto_backup = True


class SuggestDishesCollectionsData(CollectionsResourceBase):
    """
       Normalized dishes names
    """
    auto_backup = True
    releasable = True


class CollectionsBoardsRtyServer(CollectionsResourceBase):
    """
        RTY server of boards search
    """
    executable = True
    any_arch = False
    releasable = True
    release_subscribers = ['kigan']
    arcadia_build_path = 'extsearch/collections/base/boardsrtyserver/boardsrtyserver'


class CollectionsBoardsRtyServerConfigs(CollectionsResourceBase):
    """
        Configs for RTY server of boards search
    """
    releasable = True
    release_subscribers = ['kigan']
    arcadia_path = 'extsearch/collections/base/boardsrtyserver/configs'


class CollectionsBoardsDynamicModelsArchive(CollectionsResourceBase):
    """
        Configs for RTY server of boards search
    """
    releasable = True
    release_subscribers = ['kigan']


class CollectionsBoardsBanBuilder(CollectionsResourceBase):
    """
        Tool to build boards ban
    """
    releasable = True
    release_subscribers = ['kigan']
    arcadia_build_path = 'extsearch/collections/tools/build_boards_ban/build_boards_ban'


class CollectionsResourceLoader(CollectionsResourceBase):
    """
        Tool to download resource
    """
    releasable = True
    release_subscribers = ['kigan']
    arcadia_build_path = 'extsearch/collections/tools/download_sandbox_resource/download_sandbox_resource'


class CollectionsMiddlesearchBoardsBanTrie(sdk2.Resource):
    """
        Collections middle search boards ban trie
    """
    any_arch = True
    releasable = True
    releasers = ['kigan', 'panovav', 'robot-images-sandbox']
    release_subscribers = ['kigan']


class CollectionsMiddlesearchBoardsBanTrieVer(sdk2.Resource):
    """
        Collections middle search boards ban trie version
    """
    any_arch = True
    releasable = True
    releasers = ['kigan', 'panovav', 'robot-images-sandbox']
    release_subscribers = ['kigan']


class CollectionsMiddlesearchExecutable(CollectionsResourceBase):
    """
        Collections middle search server
    """
    executable = True
    any_arch = False
    releasable = True
    release_subscribers = ['kigan']
    arcadia_build_path = 'extsearch/collections/meta/collections_middlesearch/collections_middlesearch'


class CollectionsMiddlesearchShard(CollectionsResourceBase):
    """
        Collections middle search shard
    """
    any_arch = True
    releasable = True
    release_subscribers = ['kigan']


class CollectionsBoardsSearchIndexerBundle(CollectionsResourceBase):
    """
        Collections boards search indxer bundle
    """
    any_arch = True
    releasable = True
    release_subscribers = ['kigan']


class CollectionsCardRecommenderShard(CollectionsResourceBase):
    """
        Collections card recommender index shard
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class CollectionsCardRecommenderShardmap(CollectionsResourceBase):
    """
        Collections card recommender index shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shardmap = True


class CollectionsLinkBackgrounds(CollectionsResourceBase):
    """
       Set of backgrounds to use for link images from pages without og:image
    """
    auto_backup = True
    releasable = True


class CollectionsBackendTankAmmos(CollectionsResourceBase):
    """
        Tank ammos for backend loadtest
    """
    pass


class CollectionsDupsMongoSaver(CollectionsResourceBase):
    """
        Tool for saving image dups in mongo
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/quality/process/dups/mongo_saver'
    arcadia_build_name = 'mongo_saver'


class CollectionsCardRecommenderBundle(CollectionsResourceBase):
    """
        Bundle for card recommender deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True
    releasers = CollectionsResourceBase.releasers + ["paulkovalenko"]


class CollectionsMasterItemRecommenderBundle(CollectionsResourceBase):
    """
        Bundle for master item recommender deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class CollectionsTopIngredients(CollectionsResourceBase):
    """
       Ingredient names for suggest
    """
    auto_backup = True


class CollectionsExternalBansUrlsFilter(CollectionsResourceBase):
    """
        MapReduce jobs executable to filter banned urls among all urls.
    """
    basename = 'ban_urls'
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = os.path.join(PATH_TO_PODB_DIR, 'nirvana/ban_urls')
    arcadia_build_name = 'ban_urls'


class DecryptedMongoDump(CollectionsResourceBase):
    pass


class CollectionsBackupCreator(CollectionsResourceBase):
    """
        Creates backup for mongodb and launches sandbox task
    """
    any_arch = False
    auto_backup = True
    releasable = True


class CollectionsFeedBlenderBundle(CollectionsResourceBase):
    """
        Bundle for feed blender deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True
    releasers = CollectionsResourceBase.releasers + ["paulkovalenko"]


class CollectionsFeedBlender(CollectionsResourceBase):
    """
        Feed blender service
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/quality/hot_feed/blender/app'
    arcadia_build_name = 'feed_blender'


class CollectionsContentTagSuggestCache(CollectionsResourceBase):
    """
       Default values for content tags suggest
    """
    auto_backup = True


class CollectionsBackendAdminApiServer(CollectionsResourceBase):
    """Collections backend admin api server"""
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = os.path.join(PATH_TO_PODB_BACKEND_BIN, 'admin_api_server')
    arcadia_build_name = 'admin_api_server'


class CollectionsBackendApiServer(CollectionsResourceBase):
    """Collections backend api server"""
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = os.path.join(PATH_TO_PODB_BACKEND_BIN, 'api_server')
    arcadia_build_name = 'api_server'


class CollectionsBackendCeleryWorker(CollectionsResourceBase):
    """Collections backend celery worker"""
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = os.path.join(PATH_TO_PODB_BACKEND_BIN, 'celery_worker')
    arcadia_build_name = 'celery_worker'


class CollectionsBackendIpython(CollectionsResourceBase):
    """Collections backend interactive shell"""
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = os.path.join(PATH_TO_PODB_BACKEND_BIN, 'ipython')
    arcadia_build_name = 'collections_ipython'


class CollectionsBackendCeleryQueueMonitoringServer(CollectionsResourceBase):
    """Collections backend celery queue monitoring server"""
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = os.path.join(PATH_TO_PODB_DIR, 'celery-queue-monitoring')
    arcadia_build_name = 'celery_queue_monitoring'


class CollectionsCardRecommenderResponses(CollectionsResourceBase):
    """
        Card recommender responses file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class CollectionsCardRecommenderResponsesDiff(CollectionsResourceBase):
    """
        Card recommender responses diff file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class CollectionsFeedBlenderResponses(CollectionsResourceBase):
    """
        Feed blender responses file
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class CollectionsFeedBlenderResponsesAnalysis(CollectionsResourceBase):
    """
        Feed blender responses analysis result
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class CollectionsBackendMedia(CollectionsResourceBase):
    """
       Set of media files required for backend
    """
    auto_backup = True
    releasable = True


class CollectionsBackendTestData(CollectionsResourceBase):
    """
       Set of files required for backend testing
    """
    auto_backup = True
    releasable = True


class CollectionsFeedReaderPumpkinShardWriter(CollectionsResourceBase):
    """
        Tool for dumping collected pumpkin from YT to file
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/quality/hot_feed/feed_reader/index/pumpkin/writer'


class CollectionsFeedReaderPumpkinShard(CollectionsResourceBase):
    """
        Feed reader pumpkin file
    """
    auto_backup = True
    executable = False
    releasable = True


class CollectionsFeedReaderPumpkinOverlapper(CollectionsResourceBase):
    """
        Tool for overlapping users' feeds for feed reader pumpkin
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/quality/hot_feed/feed_reader/index/pumpkin/overlapper'


class CollectionsFeedReaderPumpkinReporter(CollectionsResourceBase):
    """
        Tool for building pumpkin item files
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/quality/hot_feed/feed_reader/index/pumpkin/reporter'


class CollectionsFeedReaderPumpkinUserMapping(CollectionsResourceBase):
    """
        Feed reader pumpkin user mapping
    """
    auto_backup = True
    executable = False
    releasable = True


class CollectionsFeedReaderPumpkinReportItems(CollectionsResourceBase):
    """
        Feed reader pumpkin report items
    """
    auto_backup = True
    executable = False
    releasable = True


class CollectionsFeedReaderPumpkinTopItems(CollectionsResourceBase):
    """
        Feed reader pumpkin top items
    """
    auto_backup = True
    executable = False
    releasable = True


class CollectionsFeedReaderPumpkinUserItemMapping(CollectionsResourceBase):
    """
        Feed reader pumpkin user-item mapping
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    shard = True


class CollectionsFeedReaderPumpkin(CollectionsResourceBase):
    """
        Service with feed reader pumpkin
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/quality/hot_feed/tools/pumpkin'


class CollectionsFeedReader(CollectionsResourceBase):
    """
        Feed reader service
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/quality/hot_feed/feed_reader/app'
    arcadia_build_name = 'feed_reader'


class CollectionsFeedBlenderModelsArchive(CollectionsResourceBase):
    """
        Feed blender models
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class CollectionsFeedBanTrie(CollectionsResourceBase):
    """
        Feed ban trie
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class CollectionsFeedBanTrieBuilder(CollectionsResourceBase):
    """
        Tool for building feed ban trie
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/quality/hot_feed/feed_reader/index/ban/tool'


class CollectionsCardRecommenderModelsArchive(CollectionsResourceBase):
    """
        Card recommender models
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class CollectionsBackendInstancectlConfig(CollectionsResourceBase):
    """
        instancectl.conf to run pdb_backend
    """
    any_arch = True
    executable = False
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/pdb_backend/instancectl.conf'


class CollectionsBackendAdminInstancectlConfig(CollectionsResourceBase):
    """
        instancectl.conf to run pdb_backend_public
    """
    any_arch = True
    executable = False
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/pdb_backend_admin/instancectl.conf'


class CollectionsBackendPublicInstancectlConfig(CollectionsResourceBase):
    """
        instancectl.conf to run pdb_backend_public
    """
    any_arch = True
    executable = False
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/pdb_backend_public/instancectl.conf'


class CollectionsBackendUploadInstancectlConfig(CollectionsResourceBase):
    """
        instancectl.conf to run pdb_backend_upload
    """
    any_arch = True
    executable = False
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/pdb_backend_upload/instancectl.conf'


class CollectionsWorkerInstancectlConfig(CollectionsResourceBase):
    """
        instancectl.conf to run pdb_worker
    """
    any_arch = True
    executable = False
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/pdb_worker/instancectl.conf'


class CollectionsBackendUwsgiConfig(CollectionsResourceBase):
    """
        uwsgi.conf to run pdb_backend
    """
    any_arch = True
    executable = False
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/pdb_backend/uwsgi.conf.j2'


class CollectionsBackendUwsgiSasConfig(CollectionsBackendUwsgiConfig):
    """
        uwsgi.conf to run pdb_backend
    """
    template_params = {
        'env': 'production',
        'location': 'sas',
    }


class CollectionsBackendUwsgiManConfig(CollectionsBackendUwsgiConfig):
    """
        uwsgi.conf to run pdb_backend
    """
    template_params = {
        'env': 'production',
        'location': 'man',
    }


class CollectionsBackendUwsgiVlaConfig(CollectionsBackendUwsgiConfig):
    """
        uwsgi.conf to run pdb_backend
    """
    template_params = {
        'env': 'production',
        'location': 'vla',
    }


class CollectionsBackendUwsgiTestingConfig(CollectionsBackendUwsgiConfig):
    """
        uwsgi.conf to run pdb_backend
    """
    template_params = {
        'env': 'testing',
    }


class CollectionsBackendAdminUwsgiConfig(CollectionsResourceBase):
    """
        uwsgi.conf to run pdb_backend_public
    """
    any_arch = True
    executable = False
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/pdb_backend_admin/uwsgi.conf.j2'


class CollectionsBackendPublicUwsgiConfig(CollectionsResourceBase):
    """
        uwsgi.conf to run pdb_backend_public
    """
    any_arch = True
    executable = False
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/pdb_backend_public/uwsgi.conf.j2'


class CollectionsBackendUploadUwsgiConfig(CollectionsResourceBase):
    """
        uwsgi.conf to run pdb_backend_upload
    """
    any_arch = True
    executable = False
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/pdb_backend_upload/uwsgi.conf.j2'


class CollectionsWorkerUwsgiConfig(CollectionsResourceBase):
    """
        uwsgi.conf to run pdb_worker
    """
    any_arch = True
    executable = False
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/pdb_worker/uwsgi.conf.j2'


class CollectionsPushClientConfig(CollectionsResourceBase):
    """
        push-client.conf to run push-client
    """
    any_arch = True
    executable = False
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/push_client/push-client.conf.j2'


class CollectionsUwsgiPushClientProductionConfig(CollectionsPushClientConfig):
    """
        push-client.conf for prod uwsgi
    """
    template_params = {
        'env': 'production',
        'app': 'uwsgi',
    }


class CollectionsUwsgiPushClientTestingConfig(CollectionsPushClientConfig):
    """
        push-client.conf for testing uwsgi
    """
    template_params = {
        'env': 'testing',
        'app': 'uwsgi',
    }


class CollectionsCeleryPushClientProductionConfig(CollectionsPushClientConfig):
    """
        push-client.conf for prod celery
    """
    template_params = {
        'env': 'production',
        'app': 'celery',
    }


class CollectionsCeleryPushClientTestingConfig(CollectionsPushClientConfig):
    """
        push-client.conf for testing celery
    """
    template_params = {
        'env': 'testing',
        'app': 'celery',
    }


class CollectionsPushClientHideSecretsScript(CollectionsResourceBase):
    """
        script for hiding secrets when processing data with push client
    """
    any_arch = True
    executable = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/pdb-backend/configs/push_client/hide_secrets.py'


class CollectionsBoardRecommenderModels(CollectionsResourceBase):
    """
        BoardRecommender shard2.0 models
    """
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True


class CollectionsBoardRecommenderResourceBundle(CollectionsResourceBase):
    """
        BoardRecommender shard2.0 resource bundle
    """
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True


class CollectionsRtyserverBin(CollectionsResourceBase):
    """
        Collections base-recommender rtyserver runtime executable
    """
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True


class CollectionsFastDumpBinary(CollectionsResourceBase):
    """
        Executable file for building fast dumps
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/fast_dump'
    arcadia_build_name = 'fast_dump'
    executable = True
    releasable = True


class CollectionsBanOfSurvivingEntitiesBinary(CollectionsResourceBase):
    """
        Executable file for banning/deleting of surviving entities
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/ban_of_surviving_entities'
    arcadia_build_name = 'ban_of_surviving_entities'
    executable = True
    releasable = True


class CollectionsMonitServerBinary(CollectionsResourceBase):
    """
        Monit server binary
    """
    arcadia_build_path = 'yweb/yasap/pdb/monit/monit_server'
    arcadia_build_name = 'monit_server'
    executable = True
    releasable = True


class CollectionsMergeProcessedTablesBinary(CollectionsResourceBase):
    """
        Executable file for merging processed tables (for example for common queue)
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/anti_all/merge_processed_tables'
    arcadia_build_name = 'merge_processed_tables'
    executable = True
    releasable = True


class CollectionsCommonQueueMonitorBinary(CollectionsResourceBase):
    """
        Executable file for monitoring common queues on YT
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/common_queue/monitor'
    arcadia_build_name = 'monitor'
    executable = True
    releasable = True


class CollectionsUpdateOfTeasersBinary(CollectionsResourceBase):
    """
        Build of teasers binary
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/update_teasers'
    arcadia_build_name = 'update_teasers'
    executable = True
    releasable = True


class CollectionsFilterOutSavedAssignmentsBinary(CollectionsResourceBase):
    """
        Executable file for filtering out saved assignments
    """
    arcadia_build_path = 'yweb/yasap/pdb/nirvana/filter_out_saved_assignments'
    arcadia_build_name = 'filter_out_saved_assignments'
    executable = True
    releasable = True


class CollectionsGatheredBoardsDeltaBinary(CollectionsResourceBase):
    """
        Executable file for gathering boards delta
    """
    arcadia_build_path = 'yweb/yasap/pdb/nirvana/gathered_boards_delta'
    arcadia_build_name = 'gathered_boards_delta'
    executable = True
    releasable = True


class CollectionsCardRecommender(CollectionsResourceBase):
    """
        card_recommender service
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/quality/card_recommender/runtime/app'
    arcadia_build_name = 'card_recommender'


class CollectionsSuggestMakerBinary(CollectionsResourceBase):
    """
        Binary for suggest making
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/suggest'
    arcadia_build_name = 'suggest_maker'
    executable = True
    releasable = True


class CollectionsImagesToBoardsBinary(CollectionsResourceBase):
    """
        Images to boards binary
    """
    arcadia_build_path = 'yweb/yasap/pdb/quality/process/images/to_boards/app'
    arcadia_build_name = 'images_to_boards'
    executable = True
    releasable = True


class CollectionsOfflineStatsBinary(CollectionsResourceBase):
    """
        Binary for offline stats calculating
    """
    arcadia_build_path = 'yweb/yasap/pdb/nirvana/stats/offline'
    arcadia_build_name = 'offline'
    executable = True
    releasable = True


class CollectionsSaveTopsBinary(CollectionsResourceBase):
    """
        Binary for saving tops
    """
    arcadia_build_path = 'yweb/yasap/pdb/nirvana/stats/save_tops'
    arcadia_build_name = 'save_tops'
    executable = True
    releasable = True


class CollectionsMakePreviewsBinary(CollectionsResourceBase):
    """
        Binary for make previews nirvana tool
    """
    arcadia_build_path = 'yweb/yasap/pdb/nirvana/make_previews/make_previews'
    arcadia_build_name = 'make_previews'
    executable = True
    releasable = True


class CollectionsSupportTicketProcessorBinary(CollectionsResourceBase):
    """
        Binary for processing PDBSUP tickets
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/anti_all/support_ticket_processor'
    arcadia_build_name = 'support_ticket_processor'
    executable = True
    releasable = True


class CollectionsYdbCli(CollectionsResourceBase):
    """
    YDB cli
    we are waiting for YDBREQUESTS-375 for official build
    """
    arcadia_build_path = 'kikimr/public/tools/ydb'
    arcadia_build_name = 'ydb'
    executable = True
    releasable = True


class CollectionsYdbDumpConverter(CollectionsResourceBase):
    """
    Tool for convertion ydb dump to mongo format
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/ydb_backup_converter'
    arcadia_build_name = 'ydb_backup_converter'
    executable = True
    releasable = True


class CollectionsPrepareAntiallExportsBinary(CollectionsResourceBase):
    """
    Tool for preparing antiall exports for unified queue processing
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/anti_all/prepare_exports'
    arcadia_build_name = 'prepare_exports'
    executable = True
    releasable = True


class CollectionsMongoCopyBinary(CollectionsResourceBase):
    """
    Tool for copy mongodb to YT
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/mongo_copy'
    arcadia_build_name = 'mongo_copy'
    executable = True
    releasable = True


class CollectionsMongoBackupConverter(CollectionsResourceBase):
    """
    Tool for converting mongo dump to old format
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/mongo_backup_converter'
    arcadia_build_name = 'mongo_backup_converter'
    executable = True
    releasable = True


class CollectionsUpdateOfGoodsBinary(CollectionsResourceBase):
    """
        Tool for update of goods
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/update_goods'
    arcadia_build_name = 'update_goods'
    executable = True
    releasable = True


class CollectionsOfferParserConfig(CollectionsResourceBase):
    """
       Watson offer parser config
    """
    auto_backup = True
    releasable = True


class CollectionsPushesBinary(CollectionsResourceBase):
    """
        Tool for generating pushes
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/push_notifications'
    arcadia_build_name = 'generate_push_notifications'
    executable = True
    releasable = True


class CollectionsSaasSnippetsBinary(CollectionsResourceBase):
    """
        Tool for building saas snippets data
    """
    executable = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/tools/saas_snippets'
    arcadia_build_name = 'saas_snippets'


class CollectionsExportBannedBoardsBinary(CollectionsResourceBase):
    """
        Tool for export banned boards for web search
    """
    executable = True
    releasable = True
    arcadia_build_path = 'yweb/yasap/pdb/tools/export_banned_boards'
    arcadia_build_name = 'export_banned_boards'


class CollectionsRtmrViewsBinary(CollectionsResourceBase):
    """
        Tool for build table of views from RTMR
    """
    executable = True
    releasable = True
    arcadia_build_path = "yweb/yasap/pdb/tools/rtmr_views_table_generator"
    arcadia_build_name = 'rtmr_views_table_generator'


class CollectionsPrepareAntifraudBanTablesBinary(CollectionsResourceBase):
    """
        Executable file for preparing antifraud ban tables for processing in common queue
    """
    arcadia_build_path = 'yweb/yasap/pdb/tools/anti_all/prepare_ban_tables'
    arcadia_build_name = 'prepare_ban_tables'
    executable = True
    releasable = True
