# -*- coding: utf-8 -*-

import logging

from sandbox.projects.common.BaseGetDatabaseTask import BaseGetDatabaseTask
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.projects.common.cms import get_cms_shards


class BaseGetMediaDatabaseTask(BaseGetDatabaseTask):
    """
        Базовый класс для всех тасков скачивания картиночной и видео базы
        Добавляет возможность скачать шард по умолчанию, не указывая ни имя шарда, ни ссылку для скачивания
    """

    def _get_default_shard_instance_tag(self):
        """
            Инстанс-тег, по которому искать дефолтный шард
        """
        raise NotImplementedError

    def _get_cms_configurations(self):
        """
            Шарды тестовых индексов регистрируются только в конфигурации BETA
        """
        return ['HEAD', 'BETA']

    def _get_ignored_files(self):
        return ['bin', 'experimental', 'patches', 'scripts', '_lock.tmp', 'install-*', 'thdb.tag',
                'indexed.ok', 'control']

    def _get_default_shard_name(self):
        logging.info("Looking for default shard")

        shard_names = get_cms_shards(
            instance_tag_name=self._get_default_shard_instance_tag(),
            cms_configuration=self._get_cms_configurations()[0])
        if not shard_names:
            raise SandboxTaskFailureError("Could not find any shards in CMS")

        return shard_names[0]


class BaseGetVideoDatabaseTask(BaseGetMediaDatabaseTask):
    """
        Базовый класс длявсех тасков скачивания видео базы.
        Содержит общие для всех видеобаз настройки
    """

    def _get_cms_configurations(self):
        return ["VIDEO", "BETA"]

    def _get_expected_files(self):
        return ["indexregerf2.wad", "indexinv", "indexkey", ]

    def _get_unexpected_files(self):
        return ["indexsig", ]
