# -*- coding: utf-8 -*-

from sandbox.projects.images.ImagesBuildMainIndexBinaries import ImagesBuildMainIndexBinaries

from sandbox.projects.common.BaseMediaBuildBundle_v2 import BaseMediaBuildBundle
from sandbox.projects.common.nanny import auto_deploy

from sandbox.sandboxsdk.parameters import TaskSelector


class BuildTask(TaskSelector):
    name = 'build_task'
    description = 'Task where binaries has been built'
    required = True
    task_type = (ImagesBuildMainIndexBinaries.type)


class BaseImagesBuildBundle(auto_deploy.AutoNannyDeployTask, BaseMediaBuildBundle):
    """
        Бандл для построения шарда картиночных индексов
    """

    auto_deploy = False
    raise_if_not_changed = True

    input_parameters = [BuildTask]

    def get_nanny_oauth_token(self):
        return self.get_vault_data('IMAGES-BASE-DEPLOY', 'ROBOT_IMGSBASE_NANNY_TOKEN')

    def get_build_task(self):
        return self.ctx.get(BuildTask.name)


__Task__ = BaseImagesBuildBundle
