# -*- coding: utf-8 -*-

from sandbox.projects.GetImagesMrIndexConfig import GetImagesMrIndexConfig

from sandbox.projects.common.BaseImagesBuildBundle import BaseImagesBuildBundle

from sandbox.sandboxsdk.parameters import TaskSelector


class IndexConfigTask(TaskSelector):
    name = 'index_config_task'
    description = 'Task with index config'
    required = True
    task_type = GetImagesMrIndexConfig.type


class BaseImagesBuildIndexBundle(BaseImagesBuildBundle):
    """
        Базовый класс бандла для построения картиночной базы
    """

    input_parameters = BaseImagesBuildBundle.input_parameters + [IndexConfigTask]

    def get_config_task(self):
        return self.ctx.get(IndexConfigTask.name)


__Task__ = BaseImagesBuildIndexBundle
