# -*- coding: utf-8 -*-


from sandbox.projects.common.BaseMediaBuildRobotBundles import BaseMediaBuildRobotBundles
from sandbox.projects.common.priemka.BasePriemkaTask import ArcadiaProject

from sandbox.projects.GetImagesMrIndexConfig import GetImagesMrIndexConfig

from sandbox.sandboxsdk.channel import channel


class BaseImagesBuildIndexBundles(BaseMediaBuildRobotBundles):
    """
        Base class for images index binaries building
    """

    ARCADIA_PROJECT = ArcadiaProject('images/mrindexer')

    def get_project(self):
        return self.ARCADIA_PROJECT

    def on_execute(self):
        self.__get_mr_index_config()

        BaseMediaBuildRobotBundles.on_execute(self)

    def on_release(self, additional_parameters):
        BaseMediaBuildRobotBundles.on_release(self, additional_parameters)
        config_task_id = self.ctx.get(GetImagesMrIndexConfig.type)

        if config_task_id is not None:
            self.create_release(self.ctx.get(GetImagesMrIndexConfig.type), status=additional_parameters['release_status'])

    def check_release_permissions(self, user):
        return True

    def __get_mr_index_config(self):
        if GetImagesMrIndexConfig.type in self.ctx:
            return

        subtask = channel.task.create_subtask(task_type=GetImagesMrIndexConfig.type,
                                      description=self.descr)
        self.ctx[GetImagesMrIndexConfig.type] = subtask.id

    def get_mr_index_config_task(self):
        return self.ctx.get(GetImagesMrIndexConfig.type)
