# -*- coding: utf-8 -*-

from sandbox.common.errors import SandboxException
from sandbox.sandboxsdk.parameters import SandboxStringParameter


class ShardToolReplace(SandboxStringParameter):
    name = 'shard_tool_replace'
    description = 'Shard tool for replacing (rbtorrent or resource:<id>)'
    required = False


class ShardToolConfigReplace(SandboxStringParameter):
    name = 'shard_tool_config_replace'
    description = 'Shard tool config for replacing (rbtorrent or resource:<id>)'
    required = False


class ShardWriterReplace(SandboxStringParameter):
    name = 'shard_writer_replace'
    description = 'Shardwriter for replacing (rbtorrent or resource:<id>)'
    required = False


class MapreduceReplace(SandboxStringParameter):
    name = 'mapreduce_replace'
    description = 'Mapreduce for replacing (rbtorrent or resource:<id>)'
    required = False


class ShardBuilderReplace(SandboxStringParameter):
    name = 'shard_builder_replace'
    description = 'Shard builder script for replacing (rbtorrent or resource:<id>)'
    required = False


class ShardDownloadReplace(SandboxStringParameter):
    name = 'shard_download_replace'
    description = 'Shard download binary for replacing (rbtorrent or resource:<id>)'
    required = False


class IdxOpsReplace(SandboxStringParameter):
    name = 'idx_ops_replace'
    description = 'idx_ops for replacing (rbtorrent or resource:<id>)'
    required = False


class ShardCheckerReplace(SandboxStringParameter):
    name = 'shard_checker for replacing'
    description = 'shard_checker for replacing (rbtorrent or resource:<id>)'
    required = False


class ShardWriterConfigReplace(SandboxStringParameter):
    name = 'shardwriter_config_replace'
    description = 'shardwriter config for replacing (rbtorrent or resource:<id>)'
    required = False


class ThdbReplace(SandboxStringParameter):
    name = 'thdb_replace'
    description = 'thdb for replacing (rbtorrent or resource:<id>)'
    required = False


class InstallScriptReplace(SandboxStringParameter):
    name = 'install_script_replace'
    description = 'Shard install script for replacing (rbtorrent or resource:<id>)'
    required = False


class UninstallScriptReplace(SandboxStringParameter):
    name = 'uninstall_script_replace'
    description = 'Shard uninstall script for replaceing (rbtorrent or resource:<id>)'
    required = False


class IndexBuilder(SandboxStringParameter):
    name = 'index_builder_replace'
    description = 'Index builder for replacing (rbtorrent or resource:<id>)'
    required = False


class IndexInput(SandboxStringParameter):
    name = 'index_input_replace'
    description = 'Index input for replacing (rbtorrent or resource:<id>)'
    required = False


class InputDoc(SandboxStringParameter):
    name = 'input_doc_replace'
    description = 'Input doc for replacing (rbtorrent or resource:<id>)'
    required = False


class InputDocPatcher(SandboxStringParameter):
    name = 'input_doc_patcher_replace'
    description = 'Input doc patcher for replacing (rbtorrent or resource:<id>)'
    required = False


class Metadoc(SandboxStringParameter):
    name = 'metadoc_replace'
    description = 'Metadoc for replacing (rbtorrent or resource:<id>)'
    required = False


class DocCounter(SandboxStringParameter):
    name = 'doccounter_replace'
    description = 'Doc counter for replacing (rbtorrent or resource:<id>)'
    required = False


class NNIndexer(SandboxStringParameter):
    name = 'nnindexer_replace'
    description = 'NNIndexer for replacing (rbtorrent or resource:<id>)'
    required = False


class Semidups(SandboxStringParameter):
    name = 'semidups_replace'
    description = 'Semidups for replacing (rbtorrent or resource:<id>)'
    required = False


class Planner(SandboxStringParameter):
    name = 'planner_replace'
    description = 'Planner for replacing (rbtorrent or resource:<id>)'
    required = False


class RatedConvert(SandboxStringParameter):
    name = 'rated_convert_replace'
    description = 'Rated convert for replacing (rbtorrent or resource:<id>)'
    required = False


class RemapIndex(SandboxStringParameter):
    name = 'remap_index_replace'
    description = 'Remap index for replacing (rbtorrent or resource:<id>)'
    required = False


class SelectionRank(SandboxStringParameter):
    name = 'selection_rank_replace'
    description = 'Selection rank for replacing (rbtorrent or resource:<id>)'
    required = False


class TraceRoute(SandboxStringParameter):
    name = 'trace_route_replace'
    description = 'Trace route for replacing (rbtorrent or resource:<id>)'
    required = False


class Cbir(SandboxStringParameter):
    name = 'cbir_replace'
    description = 'Cbir for replacing (rbtorrent or resource:<id>)'
    required = False


class ImgTrieBuilder(SandboxStringParameter):
    name = 'img_trie_builder_replace'
    description = 'Image trie builder for replacing (rbtorrent or resource:<id>)'
    required = False


class IdxThumb(SandboxStringParameter):
    name = 'idx_thumb_replace'
    description = 'Index thumb for replacing (rbtorrent or resource:<id>)'
    required = False


class MkImtub(SandboxStringParameter):
    name = 'mk_imtub_replace'
    description = 'MkImtub for replacing (rbtorrent or resource:<id>)'
    required = False


class Export2Ukrop(SandboxStringParameter):
    name = 'export_2_ukrop_replace'
    description = 'Export to ukrop for replacing (rbtorrent or resource:<id>)'
    required = False


class Feedback(SandboxStringParameter):
    name = 'feedback_replace'
    description = 'Feedback for replacing (rbtorrent or resource:<id>)'
    required = False


class IndexDiff(SandboxStringParameter):
    name = 'index_diff_replace'
    description = 'Index diff for replacing (rbtorrent or resource:<id>)'
    required = False


class RatedIndex(SandboxStringParameter):
    name = 'rated_index_replace'
    description = 'Rated index for replacing (rbtorrent or resource:<id>)'
    required = False


class IdxConvert(SandboxStringParameter):
    name = 'idx_convert_replace'
    description = 'Index convert for replacing (rbtorrent or resource:<id>)'
    required = False


class UserDoc(SandboxStringParameter):
    name = 'userdoc_replace'
    description = 'Userdoc for replacing (rbtorrent or resource:<id>)'
    required = False


class UserTrie(SandboxStringParameter):
    name = 'usertrie_replace'
    description = 'UserTrie for replacing (rbtorrent or resource:<id>)'
    required = False


class PornoBan(SandboxStringParameter):
    name = 'pornoban_replace'
    description = 'Pornoban for replacing (rbtorrent or resource:<id>)'
    required = False


class Cleanup(SandboxStringParameter):
    name = 'cleanup_replace'
    description = 'Cleanup for replacing (rbtorrent or resource:<id>)'
    required = False


class CbirIndexer(SandboxStringParameter):
    name = 'cbir_indexer_replace'
    description = 'Cbir indexer for replacing (rbtorrent or resource:<id>)'
    required = False


class DumpPb(SandboxStringParameter):
    name = 'dump_pb_replace'
    description = 'Dumppb for replacing (rbtorrent or resource:<id>)'
    required = False


class CmScript(SandboxStringParameter):
    name = 'cm_script_replace'
    description = 'CM script for replacing (rbtorrent or resource:<id>)'
    required = False


class IndexMergeReplace(SandboxStringParameter):
    name = 'index_merge_replace'
    description = 'indexmerge for replacing (rbtorrent or resource:<id>)'
    required = False


class UltraDaemonReplace(SandboxStringParameter):
    name = 'ultra_daemon_replace'
    description = 'ultradaemon for replacing (rbtorrent or resource:<id>)'
    required = False


class UltraDaemonConfigReplace(SandboxStringParameter):
    name = 'ultra_daemon_config_replace'
    description = 'ultradaemon config for replacing (rbtorrent or resource:<id>)'
    required = False


class InstancectlLoopConfReplace(SandboxStringParameter):
    name = 'instancectl_loop_conf_replace'
    description = 'instancectl loop conf for replacing (rbtorrent or resource:<id>)'
    required = False


class WranglerReplace(SandboxStringParameter):
    name = 'images_wrangler_replace'
    description = 'wrangler binary for replacing (rbtorrent or resource:<id>)'
    required = False


REPLACED_BY_RESOURCE = 'resource'
REPLACED_BY_TORRENT = 'rbtorrent'


def parse_resource_replace(url):
    if url.startswith('rbtorrent:'):
        return REPLACED_BY_TORRENT, url

    if url.startswith('resource:'):
        _, resource_id = url.split(':')
        return REPLACED_BY_RESOURCE, resource_id

    raise SandboxException('Can not parse resource url')
