# -*- coding: utf-8 -*-

from sandbox.projects.common.BaseMediaBuildBundle import BaseMediaBuildBundle, BaseBuildTask
from sandbox.projects.common.nanny import auto_deploy


class BuildTask(BaseBuildTask):
    task_type = 'BUILD_IMAGES_FAST_MR_INDEX_BUNDLE'


class BaseImagesFastBuildDeployBundle(auto_deploy.AutoNannyDeployTask, BaseMediaBuildBundle):
    """
        Бандл для построения шарда картиночных индексов
    """

    auto_deploy = False
    raise_if_not_changed = True

    input_parameters = [BuildTask]

    def get_nanny_oauth_token(self):
        return self.get_vault_data('IMAGES-BASE-DEPLOY', 'ROBOT_IMGSBASE_NANNY_TOKEN')

    def get_build_task(self):
        return self.ctx.get(BuildTask.name)


__Task__ = BaseImagesFastBuildDeployBundle
