# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.environments import SvnEnvironment


class BaseRpmTask(SandboxTask):

    environment = (SvnEnvironment(), )

    def get_resource_name_in_subtask_context(self, resource_type):
        '''
        функция для получения имени ресурса для помещения
        ресурса в контекст таска
        '''
        resource_name = '%s_resource' % resource_type
        return resource_name.lower()

    def resolve_resource(self, resource_name):
        '''
        получениет ресурса по имени пакета из контекста
        self.ctx['build_resources']: dict: {'имя ресурса для rpm пакета': id ресурса}
        '''
        resources = self.ctx.get('build_resources')

        if not resources:
            raise SandboxTaskFailureError('build_resources not found!')

        rpm_resource = self._read_resource(resources.get(resource_name), sync=False)

        if not rpm_resource:
            raise SandboxTaskFailureError('RPM resource %s not found!' % resource_name)

        return rpm_resource
