# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.task import SandboxTask


class FuncTestSuiteBase(SandboxTask):
    def _do_create_subtask(self, task_type, descr):
        task = self.create_subtask(task_type=task_type,
                                      host=self.host,
                                      input_parameters=self.ctx.copy(),
                                      model=self.model,
                                      arch=self.arch,
                                      description=descr)
        return task.id

    def _check_test_suite_subtasks(self, task_type, info, resources):
        subtasks = self.list_subtasks(load=True)
        if not subtasks:
            raise SandboxTaskFailureError('Subtasks not found!')
        # если упал child данного типа, то фейлим таск
        if len([s for s in subtasks if s.type == task_type and s.status == self.Status.FAILURE]):
            raise SandboxTaskFailureError("Some child failed!")

        # подгружаем ресурсы, полученные в сабтаскаx в текущий контекст
        # для последующего использования
        if resources:
            if resources not in self.ctx:
                self.ctx[resources] = {}

            for s in subtasks:
                if s.type == task_type:
                    subtask_resources = s.ctx.get(resources)
                    if subtask_resources:
                        self.ctx[resources].update(subtask_resources)

        self.set_info(info)

    def execute_subtasks(self, tasks):
        for task_type, descr, resources in tasks:
            with self.memoize_stage["create_test_suit_subtask_" + task_type](2) as st:
                # The block will be executed twice per task type.
                # At the first run we will create a sub-task and will wait for its execution.
                # At the second run we will just check it's status.
                if st.runs == 1:
                    self.wait_task_completed(self._do_create_subtask(task_type, descr))
                else:
                    self._check_test_suite_subtasks(
                        task_type=task_type,
                        info=descr + ' Done.',
                        resources=resources,
                    )

    def execute_parallel_subtasks(self, tasks):
        with self.memoize_stage.first_run:
            subtasks = [self._do_create_subtask(task_type, descr) for task_type, descr, _ in tasks]
            self.wait_all_tasks_completed(subtasks)

        for task_type, descr, resources in tasks:
            self._check_test_suite_subtasks(
                task_type=task_type,
                info=descr + ' Done.',
                resources=resources
            )
