# -*- coding: utf-8 -*-

import logging

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.errors import SandboxTaskFailureError


class NannyTask(SandboxTask):

    def _wait_all_tasks(self, nanny_client, service_id):
        """
            Ждём завершения всех тасков в сервисе няни
        """
        current_state = nanny_client.get_service_current_state(service_id)
        for snapshot in current_state['content']['active_snapshots']:
            if snapshot[u'state'] in ('GENERATING', 'ACTIVATING'):
                # wait until activating would be completed
                logging.debug(
                    'Waiting until ACTIVATING state would be completed in nanny service %s' %
                    (service_id))
                self.wait_time(30)
        # avoid race condition
        self.ctx['all_tasks_completed'] = True

    def _all_tasks_completed(self):
        return ('all_tasks_completed' in self.ctx) and self.ctx['all_tasks_completed']

    def _wait_current_task(self, nanny_client, service_id, current_snapshot):
        """
            Ждём активации определённого снепшола в сервисе няни
        """
        current_state = nanny_client.get_service_current_state(service_id)
        for snapshot in current_state['content']['active_snapshots']:
            if snapshot[u'snapshot_id'] == current_snapshot:
                if snapshot[u'state'] in ('FAILED', 'CANCELED'):
                    raise SandboxTaskFailureError(
                        'For some reason nanny task has been failed: %s' %
                        (current_snapshot))
                elif snapshot[u'state'] not in ('ACTIVE'):
                    # wait until activating would be completed
                    logging.debug(
                        'Waiting until ACTIVATING state for snapshot %s would be completed in nanny service %s' %
                        (current_snapshot, service_id))
                    return False
                else:
                    return True
