# -*- coding: utf-8 -*-
from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk import parameters
from sandbox.projects.common import utils


class ReleaseStatusParameter(parameters.SandboxStringParameter):
    name = "release_status"
    description = "Release status of tool resources"
    choices = [(x, x) for x in sandboxapi.RELEASE_STATUSES]
    default_value = sandboxapi.RELEASE_STABLE
    group = "Resource tools parameters"


class ReleasedResourceConsumer():
    """
        Mixin for a sandbox task to get last released resource by type
    """

    input_parameters = (
        ReleaseStatusParameter,
    )

    def last_released_resource(self, resource_type, override_parameter_name=None):
        """
            Returns last released resource of the given type. Release status (stable, unstable, testing etc)
            can be passed via a parameter.

            @param resource_type: resource type to find
            @param override_parameter_name: get resource from parameter with a given name
                instead of released resource
            @return: last released resource object
        """

        if override_parameter_name is not None and self.ctx.get(override_parameter_name):
            tool_id = self.ctx[override_parameter_name]
        else:
            tool_id = utils.get_and_check_last_released_resource_id(
                resource_type,
                release_status=self.ctx.get(ReleaseStatusParameter.name, sandboxapi.RELEASE_STABLE)
            )
        return self.sync_resource(tool_id)
