import os

import sandbox.common.types.client as ctc

from sandbox import sdk2


class RunCommand(sdk2.Task):
    """A task, similar in purpose to RUN_SCRIPT, with sdk2 and configurable client_tags"""

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        command = sdk2.parameters.String("Command to execute", required=True)
        vault_env = sdk2.parameters.Dict("Vault items to put in the environment")
        resource = sdk2.parameters.Resource("Resource to make available via {resource} in the command")

        client_tags = sdk2.parameters.ClientTags(
            "Client tags. May only narrow the default set of client_tags that is specified in the RunCommand.Requirements",
            default=ctc.Tag.GENERIC
        )

    def on_save(self):
        self.Requirements.client_tags = self.Parameters.client_tags

    def on_execute(self):
        command_env = os.environ.copy()
        for vault_item, env_name in self.Parameters.vault_env.items():
            command_env[env_name] = sdk2.Vault.data(vault_item)

        if self.Parameters.resource:
            resource_path = str(sdk2.ResourceData(self.Parameters.resource).path)
            command = self.Parameters.command.format(resource=resource_path)
        else:
            command = self.Parameters.command

        with sdk2.helpers.ProcessLog(self, logger="command") as pl:
            sdk2.helpers.subprocess.check_call(
                command,
                env=command_env,
                shell=True,
                stdout=pl.stdout,
                stderr=pl.stderr,
                close_fds=True
            )
