import copy
import logging

import sandbox.common as common
from sandbox import sdk2


# Used in AutocheckCMakeListsUnreachability and AutocheckDismissedOwners
class CmdCtx(object):
    def __init__(self, logName='', workDir='', outputExt='.out', errOutputExt='.err.out', wait=False, env=None,
                 stdin=None):
        self.logName = logName
        self.workDir = workDir
        self.outputExt = outputExt
        self.errOutputExt = errOutputExt
        self.wait = wait
        self.env = env
        self.stdin = stdin

    def __str__(self):
        return 'CWD = {}, stdout in {}{}, stderr in {}{}, env = {}, stdin = {}'.format(self.workDir,
                                                                                       self.logName,
                                                                                       self.outputExt,
                                                                                       self.logName,
                                                                                       self.errOutputExt,
                                                                                       str(self.env),
                                                                                       str(self.stdin))

    def Verify(self):
        if self.logName and self.workDir:
            return
        raise common.errors.TaskFailure('cmdCtx not ready: logName = ' + self.logName + '; workDir = ' + self.workDir)

    def Copy(self):
        return copy.copy(self)


# (cmd, cmdCtx) -> (return_code, stdout_filename, stderr_filename)
# Ignores outputExt, errOutputExt
def RunCmd(task, cmd, cmdCtx):
    logging.info(' '.join(cmd))
    logging.info('CmdCtx: {}'.format(str(cmdCtx)))
    cmdCtx.Verify()

    with sdk2.helpers.ProcessLog(task, logger=cmdCtx.logName) as pl:
        try:
            return_code = sdk2.helpers.subprocess.Popen(cmd, env=cmdCtx.env, cwd=cmdCtx.workDir, stdout=pl.stdout,
                                                        stderr=pl.stderr).wait()
        except Exception as exc:
            raise common.errors.TaskFailure(exc)

    return return_code, str(task.log_path(cmdCtx.logName + '.out.log')), str(task.log_path(cmdCtx.logName + '.err.log'))
