import datetime
import json


class EvTimeStamp(object):
    def __init__(self, time):
        self.seconds = float(time) / 1000000

    def GetDateTime(self):
        return datetime.datetime.fromtimestamp(int(self.seconds))


class YmakeEvLogConverter(object):
    @staticmethod
    def extract_metrics(file):
        lines = open(file).readlines()
        previous_matches = {}
        result = []
        for line in lines:
            try:
                obj = json.loads(line)
            except:
                continue
            if 'StageName' in obj and '_timestamp' in obj:
                name = obj['StageName']
                time = obj['_timestamp']
                if name not in previous_matches:
                    previous_matches[name] = time
                else:
                    diff = EvTimeStamp(time - previous_matches[name])
                    result.append((name, diff.seconds))
        return result
