import logging
import xml.etree.ElementTree as ET
import xml.dom.minidom as minidom

from sandbox.projects.common.vcs.arc import Arc

ARCADIA = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/'


def convert_diff_to_status(diff_root):
    """ Convert result of svn diff --summarize --xml
        to format for xml-to-zipatch convertor
    """
    status_root = ET.Element('status')

    for paths_item in diff_root:
        target_item = ET.SubElement(status_root, 'target')
        target_item.attrib['path'] = '.'
        for path_item in paths_item:
            entry_item = ET.SubElement(target_item, 'entry')
            entry_item.attrib['path'] = path_item.text[len(ARCADIA):]
            wc_status_item = ET.SubElement(entry_item, 'wc-status')
            wc_status_item.attrib['item'] = path_item.attrib['item']
            wc_status_item.attrib['props'] = path_item.attrib['props']

    return status_root


def gen_arc_init_command():
    logging.info('Arc client is %s', str(Arc()._client_bin))
    return [Arc()._client_bin, 'init', '--bare', '-r', 'arcadia']


def get_revision(url):
    rev = str(url.revision)
    if not rev.startswith('r'):
        rev = 'r' + rev
    return rev


def gen_arc_diff_cmd(old_url, new_url):
    return [Arc()._client_bin, 'diff', get_revision(old_url), get_revision(new_url), '--name-status', '--json', '--remote-changelist']


def gen_svn_diff_cmd(old_url, new_url):
    return ['svn', 'diff', ARCADIA, '-r'+old_url.revision+':'+new_url.revision, '--summarize', '--xml']


def gen_zipatch(vcs_info, cwd, result_path):
    import library.python.zipatch as lpzipatch
    import yalibrary.shelf.zipatch_wc_gen as wczipatch
    tree = ET.parse(vcs_info)
    root = tree.getroot()
    new_root = convert_diff_to_status(root)
    text_diff = ET.tostring(new_root)
    open(result_path+'.xml', 'w').write(minidom.parseString(text_diff).toprettyxml())
    writer = lpzipatch.ZipatchWriter()
    wczipatch.generate_for_svn_wc_status_xml_output(writer, text_diff, root=cwd, cwd=cwd)
    zipatch = result_path+'.zipatch'
    writer.save(zipatch)
    return zipatch
