import copy
import os

from sandbox import sdk2

import cmd


class YMakeExecInfo(object):
    patch = None

    def __init__(self, log_name='ymake', args=None, build_root='', path='', conf='ymake.conf', source_root='', targets=None):
        self.args = args or []
        self.build_root = build_root
        self.source_root = source_root
        self.path = path
        self.conf = conf
        self.targets = targets or []
        self.cmd_context = cmd.CmdCtx(log_name, source_root)

    def prepare_build_root(self):
        if not os.path.exists(self.build_root):
            sdk2.paths.make_folder(self.build_root)

    def get_build_root(self):
        return self.build_root

    def save_cache(self, filename, dest):
        cache_from_path = os.path.join(self.get_build_root(), filename)
        if os.path.isfile(cache_from_path):
            sdk2.paths.copy_path(cache_from_path, os.path.join(dest, filename))

    def load_cache(self, filename, src):
        cache_from_path = os.path.join(src, filename)
        if os.path.isfile(cache_from_path):
            sdk2.paths.copy_path(cache_from_path, os.path.join(self.get_build_root(), filename))

    def construct_cmd(self):
        if self.path:
            cmd_start = [self.path]
        else:
            cmd_start = [os.path.join(self.source_root, 'ya'), 'tool', 'ymake']
        if self.patch:
            cmd_start += ['-p', self.patch]
        return cmd_start + self.args + ['-B', self.build_root] + ['-c', self.conf] \
            + ['-y', os.path.join(self.source_root, 'build', 'plugins')] + self.targets

    def copy(self):
        return copy.deepcopy(self)

    def execute(self, task):
        self.prepare_build_root()
        return cmd.RunCmd(task, self.construct_cmd(), self.cmd_context)
