import time
import datetime
import logging
from sandbox.sandboxsdk.svn import Arcadia
prio = {1: "critical", 2: "important", 3: "noncritical"}


def get_data_for_db(results, priorities, prev_broken_methods):
    broken_tag_list = []
    broken_tag = []
    muted_tag = []
    tags = []
    ban_owners = {}
    ban_methods_tags = {}
    prev_broken_methods_owners = {}
    prev_broken_methods_tags = {}
    for ban_name, ban_result in results['methods'].items():
        # Priorities:
        # 1 = critical, 2 = important, 3 = not critical, no priority => 3 = not critical
        # need only critical and important
        ban_type = ban_result.get('type', 'check ban')
        if ban_type != 'check ban' and ban_type != 'check saved_copy':
            # not interested in 'check diff'
            continue
        ban_tag = ban_result.get('tag', '')

        if ban_name in priorities and priorities[ban_name] < 3:
            if ban_tag not in tags:
                tags.append(ban_tag)
            if ban_result.get('muted', False):
                muted_tag.append(ban_tag)
            elif ban_result['number_error'] > ban_result['limit']:
                logging.info("'%s' (in tag %s): errors %s, limit %s => broken" % (ban_name, ban_tag, ban_result['number_error'], ban_result['limit']))
                if ban_tag not in broken_tag:
                    broken_tag.append(ban_tag)
                    broken_tag_list.append(get_comment(ban_tag, prev_broken_methods))
        get_statatistic_for_item(prev_broken_methods_owners, ban_result["owner"], ban_tag, ban_owners,
                                  ban_result, ban_name, priorities)
        get_statatistic_for_item(prev_broken_methods_tags, ban_tag, ban_name, ban_methods_tags,
                                  ban_result, ban_name, priorities)

    comment = 'BROKEN: ' + ''.join(broken_tag_list) if broken_tag_list else ''
    working_tag = [tag for tag in tags if tag not in broken_tag and tag not in muted_tag]
    logging.info("Result: %s working, %s muted, %s broken, comment: '%s'" % (len(working_tag), len(muted_tag), len(broken_tag), comment))
    return (len(working_tag), len(muted_tag), len(broken_tag), comment, ban_owners, ban_methods_tags)


def get_statatistic_for_item(prev_broken_item, item, aggr_name, ban_item, ban_result, ban_name, priorities):
    if item not in prev_broken_item:
        prev_broken_item[item] = prev_broken_methods_item(item)
    if item not in ban_item:
        ban_item[item] = {"broken": [], "items": [], "broken_list": [], "uptime": {
            "critical": [],
            "important": [],
            "noncritical": []
        }}
    if priorities.get(ban_name, 3) != 3:
        if aggr_name not in ban_item[item]['items']:
            ban_item[item]['items'].append(aggr_name)

        if ban_result['number_error'] > ban_result['limit']:
            if aggr_name not in ban_item[item]['broken']:
                ban_item[item]['broken'].append(aggr_name)
                ban_item[item]['broken_list'].append(get_comment(aggr_name, prev_broken_item[item]))

    if "uptime" in ban_result and ban_result["uptime"] > 0 \
            and "date_good" in ban_result and ban_result["date_good"] == ban_result["timestamp_start"]:
        ban_item[item]["uptime"][prio[priorities.get(ban_name, 3)]].append([
            ban_result["timestamp_start"],
            ban_result["uptime"],
            "%s %s" % (aggr_name, datetime.timedelta(seconds=ban_result["uptime"]))
        ])


def get_comment(ban_name, prev_broken_methods):
    if ban_name not in prev_broken_methods:
        ban_name = "<strong>%s</strong>" % ban_name
    return "<p>%s</p>" % ban_name


def prev_broken_methods_item(owner):
    from infra_db import InfraDBCursor
    prev_broken_methods = ''
    with InfraDBCursor() as cur:
        cur.execute("select comment from bad_data where label='bad_%s' order by id desc limit 1" % owner)
        for item in cur:
            if item and not item[0] is None:
                prev_broken_methods = item[0]
    #logging.info("owner %s  broken %s" % (owner, prev_broken_methods))
    return prev_broken_methods


def put_results_from_str_to_db(str_ban, timestamp):
    from charts_data import db_put_chart_point
    for item in str_ban:
        comment_broken = 'BROKEN: ' + ''.join(str_ban[item]["broken_list"]) if str_ban[item]["broken_list"] else ''
        db_put_chart_point("bad_" + item, timestamp, len(str_ban[item]["broken"]), table='bad_data', comment=comment_broken)
        logging.info("write str_ban[%s]['broken']=%d comment=%s" % (item, len(str_ban[item]["broken"]), comment_broken))

        working = [i for i in str_ban[item]["items"] if i not in str_ban[item]["broken"]]
        len_working = len(working)
        comment_working = "<p>" + ('</p><p>'.join(working) if working else '') + "</p>"
        db_put_chart_point("good_" + item, timestamp, len_working, table='good_data', comment=comment_working)
        logging.info("write str_ban[%s]['working']=%d comment=%s" % (item, len_working, comment_working))

        for prio in str_ban[item]["uptime"]:
            for uptime in str_ban[item]["uptime"][prio]:
                if len(uptime) > 2 and uptime[1] > 0:
                    if prio == "critical":
                        # hour
                        average_uptime = round(uptime[1] / float(60 * 60), 2)
                    else:
                        # day
                        average_uptime = round(uptime[1] / float(24 * 60 * 60), 2)
                    try:
                        db_put_chart_point("uptime_%s_%s" % (prio, item), uptime[0], average_uptime, table='uptime_data', comment=uptime[2])
                        logging.info("write uptime item=%s prio=%s uptime=%d (%s) timestamp=%d for %s" % (item, prio, uptime[1], str(average_uptime), uptime[0], uptime[2]))
                    except:
                        logging.warning("data for %s exist" % (item + "_uptime_" + prio))


def put_results_to_db(results_hash):
    timestamp = int(time.time())
    Arcadia.export('arcadia:/arc/trunk/arcadia/yweb/antispam/zenith/viewers/antispam/bans/ban_prio.py', './')
    Arcadia.export('arcadia:/arc/trunk/arcadia/yweb/antispam/scripts/script_lib/charts_data.py', './')
    Arcadia.export('arcadia:/arc/trunk/arcadia/yweb/antispam/scripts/script_lib/infra_db.py', './')
    from ban_prio import PriorityBan
    from charts_data import db_put_chart_point
    prev_broken_methods = prev_broken_methods_item('antispam_stat')

    # process data and get data for db
    (working_tag, muted_tag, broken_tag, comment, ban_owner, ban_tags) = get_data_for_db(results_hash, PriorityBan, prev_broken_methods)

    db_put_chart_point('bad_antispam_stat', timestamp, broken_tag, comment, table='bad_data')
    db_put_chart_point('good_antispam_stat', timestamp, working_tag, table='good_data')
    db_put_chart_point('muted_antispam_stat', timestamp, muted_tag, table='muted_data')

    put_results_from_str_to_db(ban_owner, timestamp)
    put_results_from_str_to_db(ban_tags, timestamp)
