"""
    Wrapper used for convert apphost requests and responses
"""
# import base64
import json
import logging
import subprocess


def convert_input_request(converter_exe_path, request):
    """
        :param converter_exe_path: path to apphost converter (apphost/tools/converter)
        :param request: apphost request context
        :return: apphost request in json format
    """
    out = convert_input_request_to_str(converter_exe_path, request)
    return _to_json(out)


def convert_input_request_to_str(converter_exe_path, request):
    proc = subprocess.Popen(
        [converter_exe_path, '--input-format', 'service_request'],
        stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE
    )
    out, err = proc.communicate(request)
    if proc.returncode:
        raise Exception("Fail to convert input request:\n{}\nRequest:\n{}".format(err, request))
    return out


def convert_input_response(converter_exe_path, response, plain_text=False):
    """
        :param converter_exe_path: path to apphost converter (apphost/tools/converter)
        :param response: apphost response context
        :param plain_text: return plain text response instead of json
        :return: apphost response in json format
    """
    # logging.debug("Try to convert response: %s", base64.encodestring(response))
    proc = subprocess.Popen(
        [converter_exe_path, '--input-format', 'service_response'],
        stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE
    )
    out, err = proc.communicate(response)
    if proc.returncode:
        raise Exception("Fail to convert input response:\n{}\nResponse:\n{}".format(err, response))
    if plain_text:
        return out
    return _to_json(out)


def convert_output_request(converter_exe_path, request):
    """
        :param converter_exe_path: path to apphost converter (apphost/tools/converter)
        :param request: apphost request in json format
        :return: apphost request as a string
    """
    str_req = json.dumps(request)
    out = convert_output_request_from_str(converter_exe_path, str_req)
    return out


def convert_output_request_from_str(converter_exe_path, request_as_str):
    proc = subprocess.Popen(
        [converter_exe_path, '--output-format', 'service_request'],
        stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE
    )
    out, err = proc.communicate(request_as_str)
    if proc.returncode:
        raise Exception("Fail to convert output request:\n{}\nRequest:\n{}".format(err, request_as_str))
    return out


def _to_json(s):
    try:
        return json.loads(s)
    except Exception:
        try:
            return json.loads(s.decode('latin-1'))
        except Exception:
            logging.error("Failed to decode json: %s", s)
            raise
