"""
    For patching apphost requests and responses
"""

ADD = "__add__"
REMOVE = "__remove__"
FORCE_REPLACE = "__force_replace__"  # replace or add if not exist
WEAK_REPLACE = "__weak_replace__"  # replace or do nothing if not exist


def patch_global_ctx(apphost_req, patch):
    """
        In place patch for decoded apphost requests
        :param apphost_req: decoded json request context
        :param patch: dict (or list of tuples) with fields to patch
            {
                "__add__": {
                    u"pron": [u"norandomgroupselection", u"nosmfa"],
                }
                "__remove__": {u"debug": [u"eventlogs"]},
            }
            or
            [{"__add__": (u"pron", [u"norandomgroupselection", u"nosmfa"])}]
    """
    for answer in apphost_req["answers"]:
        results = answer["results"]
        for result in (results if isinstance(results, (list, tuple)) else [results]):
            if "global_ctx" in result:
                for param_name, param_vals in iter_over_patch(patch.get(REMOVE)):
                    if param_name in result["global_ctx"]:
                        patched_param_vals = result["global_ctx"][param_name]
                        for val in param_vals:
                            if val in patched_param_vals:
                                patched_param_vals = filter_values(patched_param_vals, val)
                        if patched_param_vals:
                            result["global_ctx"][param_name] = patched_param_vals
                        else:
                            del result["global_ctx"][param_name]
                for param_name, param_vals in iter_over_patch(patch.get(ADD)):
                    patched_param_vals = result["global_ctx"].get(param_name, [])
                    for val in param_vals:
                        if val not in patched_param_vals:
                            patched_param_vals.append(val)
                    result["global_ctx"][param_name] = patched_param_vals
                for param_name, param_vals in iter_over_patch(patch.get(FORCE_REPLACE)):
                    result["global_ctx"][param_name] = list(param_vals)
                for param_name, param_vals in iter_over_patch(patch.get(WEAK_REPLACE)):
                    init_param_vals = result["global_ctx"].get(param_name)
                    if init_param_vals:
                        result["global_ctx"][param_name] = list(param_vals)


def iter_over_patch(patch):
    if isinstance(patch, dict):
        return patch.iteritems()
    elif isinstance(patch, (list, tuple)):
        return patch
    return []


def filter_values(the_list, val):
    return [value for value in the_list if value != val]
