import logging

from sandbox.projects.common.app_host.options import get_verticals
import sandbox.projects.common.constants as consts

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.sandboxapi import TASK_FINISHED


_CTX_VERTICALS = 'verticals'
_CTX_CONF_REVISION = 'conf_revision'


def _get_revision(ctx):
    raw_url = ctx[consts.ARCADIA_URL_KEY]
    arcadia_url = Arcadia.parse_url(raw_url)
    assert arcadia_url.trunk

    return arcadia_url.revision or Arcadia.get_revision(raw_url)


def save_run_info(ctx):
    ctx[_CTX_VERTICALS] = get_verticals(ctx)
    ctx[_CTX_CONF_REVISION] = _get_revision(ctx)


def has_changes_since_prev_run(ctx, task_type, arc_path):
    prev_runs = channel.sandbox.list_tasks(task_type=task_type, limit=100, status=TASK_FINISHED)
    prev_revision = None
    prev_run = None

    verticals = get_verticals(ctx)
    logging.info('verticals: %s' % verticals)
    for run in prev_runs:
        run_verticals = run.ctx.get(_CTX_VERTICALS)
        logging.info('run verticals: %s' % run_verticals)
        if run_verticals == verticals:
            prev_run = run
            break

    if prev_run is not None:
        prev_revision = prev_run.ctx.get(_CTX_CONF_REVISION)
        logging.info('prev run: %s' % prev_run.id)
    else:
        logging.warn('no prev runs')

    raw_arcadia_url = ctx[consts.ARCADIA_URL_KEY]
    this_revision = _get_revision(ctx)

    if prev_revision is not None:
        if prev_revision == this_revision:
            logging.warn('no changes in arcadia since last run')
            return False

        idx = raw_arcadia_url.rfind('@')
        if idx >= 0:
            raw_arcadia_url = raw_arcadia_url[:idx]
        if raw_arcadia_url.endswith('/'):
            raw_arcadia_url = raw_arcadia_url[:-1]
        raw_arcadia_url += ('/' if not arc_path.startswith('/') else '') + arc_path
        logging.info('collecting changelist for svn url %s, revs: (%s, %s]' % (raw_arcadia_url, prev_revision, this_revision))
        changelist_size = len(Arcadia.log(raw_arcadia_url, str(int(prev_revision) + 1), this_revision))
        logging.info('changelist size: %s' % changelist_size)

        return changelist_size > 0
    else:
        logging.warn('no prev revision')

    return True
