from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxTaskUnknownError

from multiprocessing import Queue

import logging
import threading


def get_data_from_proc(pq_tuple):
    p, q = pq_tuple
    p.join()
    d = q.get()
    if isinstance(d, Exception):
        raise d
    return d


class AsyncResDownloadTask(SandboxTask):
    RES_KEYS_ASYNC_DOWNLOAD = []

    def get_res(self, res_id, q):
        try:
            res = channel.task.sync_resource(res_id)
            q.put(res)
        except Exception as err:
            logging.exception("Error occurred during resource #%s download", res_id)
            q.put(SandboxTaskUnknownError("Error while getting %s. Err message: %s" % (res_id, err)))

    def get_res_async(self, res_id):
        q = Queue()
        p = threading.Thread(target=self.get_res, args=(res_id, q))
        p.start()
        return p, q

    def start_async_download(self):
        procs = {}
        for res_name in self.RES_KEYS_ASYNC_DOWNLOAD:
            if self.ctx[res_name]:
                procs[res_name] = self.get_res_async(self.ctx[res_name])
        return procs

    def get_results_async_download(self, procs):
        results = {}
        for res_name in procs:
            results[res_name] = self.get_results_from_special_proc(procs, res_name)
        return results

    def get_results_from_special_proc(self, procs, name):
        return get_data_from_proc(procs[name])
