from sandbox.projects import resource_types
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.process import run_process

import os


class AutocheckCompareLogsBase(SandboxTask):
    type = 'AUTOCHECK_COMPARE_LOGS_BASE_TASK'

    def CompareLogs(self, logs1Parameter, logs2Parameter):
        logs1 = self.sync_resource(self.ctx[logs1Parameter.name])
        logs2 = self.sync_resource(self.ctx[logs2Parameter.name])

        file1_path = os.path.join(logs1, logs1Parameter.compared_file_name)
        file2_path = os.path.join(logs2, logs2Parameter.compared_file_name)

        diff_resource_path = self.abs_path('compare_result.txt')

        cmd = ["diff", "-u", file1_path, file2_path]

        with open(diff_resource_path, 'wb') as file:
            run_process(cmd, stdout=file, wait=True, check=False, timeout=10)

        if os.path.getsize(diff_resource_path) > 0:
            self.create_resource(self.descr, diff_resource_path, resource_types.AUTOCHECK_LOGS_DIFF, arch='any')
            self.ctx['has_diff'] = True
        else:
            self.ctx['has_diff'] = False
