# -*- coding: utf-8 -*-
import os
import sandbox.sdk2 as sdk2
from sandbox.projects.common.backend_build_pipeline.BuildAndReleaseOnCommitNotifier import BuildAndReleaseOnCommitNotifier, with_build_and_release_on_commit_notifier_parameters
from sandbox.projects.common.build.KosherYaMake import KosherYaMake
from sandbox.projects.common.build.YaMake2 import ResultResourceTypeParameter


class BuildResourceAndNotifyTelegram(BuildAndReleaseOnCommitNotifier, KosherYaMake):
    """
    Task for building arbitrary resource and notify about build and release to telegram chats
    """
    class Parameters(with_build_and_release_on_commit_notifier_parameters(KosherYaMake.Parameters)):
        result_rt = ResultResourceTypeParameter()

    @property
    def tool_name(self):
        return self.Parameters.result_rt

    def get_context_override(self):
        return {
            'result_single_file': True,
        }

    def get_targets(self):
        resource = sdk2.Resource[self.Parameters.result_rt]
        return [resource.arcadia_build_path]

    def get_arts(self):
        resource = sdk2.Resource[self.Parameters.result_rt]
        return [
            {
                'path': os.path.join(
                    resource.arcadia_build_path, resource.arcadia_build_name
                )
            }
        ]

    def get_resources(self):
        resource = sdk2.Resource[self.Parameters.result_rt]
        return {
            resource.arcadia_build_name: {
                'resource_type': resource,
                'description': resource.__doc__,
                'resource_path': resource.arcadia_build_name,
            }
        }

    def on_execute(self):
        KosherYaMake.on_execute(self)
        self.notify_on_build()

    def on_release(self, additional_parameters):
        KosherYaMake.on_release(self, additional_parameters)
        self.notify_on_release(additional_parameters)
