from .tree import node as tree_node
from sandbox.projects.common.search.response import patterns


def compress_formula_and_factors(response):
    def compress(node):
        if node.GetPropValue("Key") == "_RelevFormula":
            s = node.GetPropValue("Value")

            match_model = patterns.MODEL_TEMPLATE.search(s)
            match_polynom = patterns.POLYNOM_TEMPLATE.search(s)

            # For backward compatibility: node was already patched by response_saver
            if match_model or match_polynom:
                value = ""
                if match_model:
                    value += match_model.group(1)

                if match_polynom:
                    value += " ({})".format(match_polynom.group(1))

                node._props["Value"] = ['"{}"'.format(value)]

        elif node.GetPropValue("Key") == "_RelevFactors":
            value = node.GetPropValue("Value")
            node._props["Value"] = ['"{}"'.format(patterns.compress_factors(value))]

    def process_document(document):
        tree_node.WalkPath(document, ["FirstStageAttribute"], lambda attr: compress(attr))
        tree_node.WalkPath(document, ["ArchiveInfo", "GtaRelatedAttribute"], lambda attr: compress(attr))

    tree_node.WalkPath(response, ["Grouping", "Group", "Document"], process_document)
