from sandbox.sandboxsdk import parameters as sp

from sandbox.projects import resource_types
import sandbox.projects.websearch.middlesearch.resources as ms_resources


# widely used context keys
USE_BINARY_RESPONSES_KEY = 'get_responses_from_binary'
UNSTABLE_OUTPUT_KEY = 'unstable_output'

GROUP_NAME = 'Response saver params'


def create_response_saver_params(
    queries_resource=None,
    required_queries=True,
):
    queries_resources = queries_resource or [
        resource_types.PLAIN_TEXT_QUERIES,
        ms_resources.WebMiddlesearchPlainTextQueries,
        resource_types.IMAGES_MIDDLESEARCH_PLAIN_TEXT_REQUESTS,
        resource_types.VIDEO_MIDDLESEARCH_PLAIN_TEXT_REQUESTS,
    ]

    class Params:
        class QueriesParameter(sp.ResourceSelector):
            name = 'queries_resource_id'
            description = 'Source queries'
            resource_type = queries_resources
            group = GROUP_NAME
            required = required_queries

        class QueriesLimitParameter(sp.SandboxIntegerParameter):
            name = 'queries_limit'
            description = 'Limit number of queries to read (0 = all)'
            group = GROUP_NAME
            default_value = 0

        class RecheckResultsNTimesParameter(sp.SandboxIntegerParameter):
            name = 'recheck_results_n_times'
            description = 'Recheck results N times'
            group = GROUP_NAME
            default_value = 0

        class MaxRetriesForEveryQuery(sp.SandboxIntegerParameter):
            """Works only with requester_compat"""
            name = 'max_retries_for_every_query'
            description = 'Retry every query N times (0 - ask once)'
            group = GROUP_NAME
            default_value = 0

        class StabilizeResponses(sp.SandboxBoolParameter):
            """
                Adds cgi params to query, that stabilise production-like responses
                Works only with requester_compat
            """
            name = 'stabilize_responses'
            description = 'Stabilize responses'
            group = GROUP_NAME
            default_value = False

        class MinOutputSizeParameter(sp.SandboxIntegerParameter):
            """Only for old response_saver"""
            name = 'min_output_size'
            description = 'Min output size (0 = unlimited)'
            group = GROUP_NAME
            default_value = 0

        class MinAvgOutputSizeParameter(sp.SandboxIntegerParameter):
            """Only for old response_saver"""
            name = 'min_avg_output_size'
            description = 'Min average output size (0 = unlimited)'
            group = GROUP_NAME
            default_value = 0

        class GetAllFactorsParameter(sp.SandboxBoolParameter):
            name = 'get_all_factors'
            description = 'Get all factors (add gta=_RelevFactors)'
            group = GROUP_NAME
            default_value = False

        class SaveResponsesImmediatelyParameter(sp.SandboxBoolParameter):
            """Only for old response_saver"""
            name = 'save_responses_immediately'
            description = 'Save responses immediately (debug)'
            group = GROUP_NAME
            default_value = False

        class IgnoreGotErrorParameter(sp.SandboxBoolParameter):
            """Only for old response_saver"""
            name = 'ignore_got_error'
            description = 'Ignore basesearch GotError'
            group = GROUP_NAME
            default_value = False

        class RemoveIg(sp.SandboxBoolParameter):
            """Only for old response_saver"""
            name = 'remove_ig'
            description = 'Remove Ig SearcherProp (unstable, SEARCH-1186)'
            group = GROUP_NAME
            default_value = False

        class SavePatchedQueriesParameter(sp.SandboxBoolParameter):
            """Only for old response_saver"""
            name = 'save_patched_queries'
            description = 'Save patched queries'
            default_value = False
            group = GROUP_NAME

        class UseBinaryResponses(sp.SandboxBoolParameter):
            name = USE_BINARY_RESPONSES_KEY
            description = 'Binary responses (no hr=da)'
            group = GROUP_NAME
            default_value = False

        class UseDCFM(sp.SandboxBoolParameter):
            name = 'use_dcfm'
            description = 'Use DCFM (SEARCH-841)'
            group = GROUP_NAME
            default_value = False

        class TestWithCacheDisabled(sp.SandboxBoolParameter):
            name = 'test_disabled_cache'
            description = 'Test stability with disabled cache'
            group = GROUP_NAME
            default_value = False

        class TestWithDoubledQueries(sp.SandboxBoolParameter):
            name = 'test_doubled_queries'
            description = 'Test stability with doubled queries'
            group = GROUP_NAME
            default_value = False

        class AdditionalCgiParams(sp.SandboxStringParameter):
            name = 'additional_cgi_params'
            description = 'Additional CGI params'
            group = GROUP_NAME
            default_value = ''

        class DecompressFactors(sp.SandboxBoolParameter):
            # See SEARCH-6940
            name = 'decompress_factors'
            description = 'Decompress factors'
            default_value = True
            group = GROUP_NAME

        class MaxFailRate(sp.SandboxFloatParameter):
            name = 'max_fail_rate'
            description = 'Max fail rate (SEARCH-2084)'
            group = GROUP_NAME
            default_value = 0.0

        params = (
            QueriesParameter,
            QueriesLimitParameter,
            AdditionalCgiParams,
            UseBinaryResponses,
            RecheckResultsNTimesParameter,
            MaxRetriesForEveryQuery,
            MinOutputSizeParameter,
            MinAvgOutputSizeParameter,
            GetAllFactorsParameter,
            SaveResponsesImmediatelyParameter,
            IgnoreGotErrorParameter,
            RemoveIg,
            SavePatchedQueriesParameter,
            UseDCFM,
            TestWithCacheDisabled,
            TestWithDoubledQueries,
            StabilizeResponses,
            DecompressFactors,
            MaxFailRate,
        )

    return Params


DefaultResponseSaverParams = create_response_saver_params()
