# coding: utf-8
from sandbox.projects.common.base_search_quality import snipdiff
from sandbox.projects.common.differ import printers


def _gen_simple_diff(dict_info, sorting_key=lambda x: x[0]):
    result = []
    if dict_info != {}:
        sorted_items = sorted(dict_info.items(), key=sorting_key)
        for line in sorted_items:
            if len(line) == 2:
                result.append('{:<20}: {:>10}'.format(line[0], line[1]))
            else:
                result.append('    '.join(line))
    return '\n'.join(result)


def _generate_html_table(dict_info, column_names, sorting_key=lambda x: x[0]):
    table = []
    if dict_info != {}:
        table.append('<table border="1">')
        table.append('<tr>')
        table.extend(['<th>{}</th>'.format(name) for name in column_names])
        table.append('</tr>')
        for line in sorted(dict_info.iteritems(), key=sorting_key):
            table.append('<tr>')
            for element in line:
                if isinstance(element, list) or isinstance(element, tuple):
                    table.extend(['<td>{}</td>'.format(e) for e in element])
                else:
                    table.append('<td>{}</td>'.format(element))
            table.append('</tr>')
        table.append('</table>')
    return "".join(table)


def _get_bg_color(block_type):
    if block_type == 'Changed':
        return printers.DiffType.CHANGED
    elif block_type == 'Unchanged':
        return printers.DiffType.NODIFF
    elif block_type == 'Added':
        return printers.DiffType.ADDED
    elif block_type == 'Removed':
        return printers.DiffType.REMOVED


def _start_colored_block(title, block_type):
    return printers.HtmlBlock.start(title, bg_class=_get_bg_color(block_type))


def _repr_keyval_pair(dict_to_repr):
    out = []
    for change_type, values in dict_to_repr.items():
        if values:
            if isinstance(values, dict):
                out.append(_start_colored_block(change_type, block_type=change_type))
                if change_type == 'Changed':
                    out.append(_generate_html_table(values, ['Factor', 'Old Value', 'New Value']))
                else:
                    out.append(_gen_simple_diff(values))
                out.append(printers.HtmlBlock.end())
            elif isinstance(values, tuple) and len(values) == 2:
                out.extend([
                    _start_colored_block(change_type, block_type=change_type),
                    printers.HtmlBlock.simple_data(values[0], printers.DiffType.REMOVED),
                    printers.HtmlBlock.simple_data(values[1], printers.DiffType.ADDED),
                    printers.HtmlBlock.end()
                ])
            else:
                out.extend([
                    _start_colored_block(change_type, block_type=change_type),
                    values,
                    printers.HtmlBlock.end()
                ])

    return "\n".join(out)


def repr_dictionary(snip, snip_type):
    out = {}
    if snip_type in ['Changed', 'Unchanged']:
        for Key, Value in snip.Dict.iteritems():
            if Value:
                out[Key] = _repr_keyval_pair(Value)
    else:
        for Key, Value in snip.Dict.iteritems():
            if Value:
                out[Key] = _repr_keyval_pair({snip_type: Value})
    return out


def repr_entities(file_obj, x, y):
    global_result = snipdiff.global_compare(x, y)
    for algo_dict_type, algo_dict in global_result.iteritems():
        file_obj.write(_start_colored_block("{} Algo Group".format(algo_dict_type), block_type=algo_dict_type))
        for algo_name, pairs in algo_dict.iteritems():
            file_obj.write(
                _start_colored_block('{} ({} diffs)'.format(algo_name, len(pairs.values())), block_type=algo_dict_type)
            )
            repr_pairs(file_obj, pairs, algo_dict_type)
            file_obj.write(printers.HtmlBlock.end())
        file_obj.write(printers.HtmlBlock.end())


def repr_pairs(file_obj, algo_pairs, algo_type):
    for snip in algo_pairs.itervalues():
        snippet = repr_dictionary(snip, algo_type)
        headings = ['Key', 'Value']
        file_obj.write("\n".join([
            _start_colored_block('{} Snippet'.format(algo_type), algo_type),
            printers.HtmlBlock.simple_data(_generate_html_table(snippet, headings), escape=False),
            printers.HtmlBlock.end(),
        ]))
