#!/usr/bin/env python

import socket
import httplib
import urllib2
import struct


class TZeroLingerHTTPConnection(httplib.HTTPConnection):
    def connect(self):
        httplib.HTTPConnection.connect(self)
        self.sock.setsockopt(socket.SOL_SOCKET, socket.SO_LINGER, struct.pack('ii', 1, 0))


class TZeroLingerHTTPHandler(urllib2.HTTPHandler):
    def http_open(self, req):
        return self.do_open(TZeroLingerHTTPConnection, req)


_opener = urllib2.build_opener(TZeroLingerHTTPHandler)

urlopen = _opener.open
