# coding: utf-8

"""
Generic Beta API, appropriately switching between SDMS and Yappy
"""

import logging

from .api_interface import ApiInterface
from .yappy_api import YappyApi

YAPPY_URL = "https://yappy.z.yandex-team.ru/"


class BetaApi(ApiInterface):  # todo: remove this wrapper after complete removing sdms api
    @classmethod
    def fromurl(
        cls,
        yappy_url=YAPPY_URL,
        token=None,
        timeout=30,
        ssl_verify=False,
        id=None,
    ):
        return cls(
            YappyApi(srv=yappy_url, token=token, timeout=timeout, ssl_verify=ssl_verify, id=id)
        )

    def __init__(self, yappy):
        self.yappy = yappy
        self.logger = logging.getLogger(__name__)

# Basic methods:

    def beta_exists(self, beta_name):
        """
        Check if beta exists in SDMS or Yappy
        :return: True/False
        """
        return self.yappy.beta_exists(beta_name)

    def api(self, beta_name=None):
        return self.yappy

    def get_beta_info(self, beta_name):
        return self.api().get_beta_info(beta_name)

    def get_beta_state(self, beta_name):
        return self.api().get_beta_state(beta_name)

    def stop_beta(self, beta_name):
        return self.api().stop_beta(beta_name)

    def start_beta(self, beta_name):
        return self.api().start_beta(beta_name)

    def get_instances(self, beta_name, source):
        return self.api(beta_name).get_instances(beta_name, source)

    def create_beta_from_template(self, template_name, suffix, patches):
        return self.api().create_beta_from_template(template_name, suffix, patches)

# Compound methods based on basic interface:

    def is_beta_consistent(self, beta_name, target_version=None):
        if not self.beta_exists(beta_name):
            return None
        beta_info = self.get_beta_info(beta_name)
        status = beta_info["state"]["status"]
        if status == "CONSISTENT":
            if target_version is not None:
                version = beta_info["configuration"]["version"]
                logging.debug("Target version = %s, real version = %s", target_version, version)
                return int(version) >= int(target_version)
            return True
        return False

    def retrieve_api_beta_template(self, template_name):
        return self.api().retrieve_api_beta_template(template_name)

    def update_patches(self, beta_name, patches):
        return self.api().update_patches(beta_name, patches)

    def retrieve_api_beta(self, beta_name):
        return self.api().retrieve_api_beta(beta_name)
