import xmlrpclib
import json


def json_response(fn):
    def res(*args, **kwargs):
        return json.loads(fn(*args, **kwargs))
    return res


class FmlConfigClient(object):

    def __init__(self, server, oauth):
        self.server = xmlrpclib.ServerProxy(server, allow_none=True)
        self.oauth = oauth

    @json_response
    def get_prod(self, vertical, ui, tld, svn_branch='trunk', all_formulas=False, get_config_node=False):
        return self.server.get_production({
            'vertical': vertical,
            'ui': ui,
            'tld': tld,
            'svn_branch': svn_branch,
            'all_formulas': all_formulas,
            'get_config_node': get_config_node
        })

    @json_response
    def get_experiments_status(self, svn_branch):
        return self.server.get_experiments_status({
            'svn_branch': svn_branch
        })

    @json_response
    def get_diff(self, svn_branch_old, svn_branch_new, full, explained):
        return self.server.get_diff({
            'svn_branch_old': svn_branch_old,
            'svn_branch_new': svn_branch_new,
            'full': full,
            'explained': explained
        })

    @json_response
    def get_verticals(self, svn_branch):
        return self.server.get_verticals({
            'svn_branch': svn_branch
        })

    @json_response
    def get_locales(self, svn_branch):
        return self.server.get_locales({
            'svn_branch': svn_branch
        })

    @json_response
    def get_uis(self):
        return self.server.get_uis()

    @json_response
    def get_fml_by_md5(self, md5):
        return self.server.get_fml_by_md5({
            'md5': md5,
        })

    @json_response
    def get_rd_releases(self, skip_cancelled=False):
        return self.server.get_rd_releases({
            'skip_cancelled': skip_cancelled
        })

    @json_response
    def get_rd_release_info(self, sandbox_task):
        return self.server.get_rd_release_info({
            'sandbox_task': sandbox_task,
        })

    @json_response
    def get_formula(self, fml_name, svn_branch):
        return self.server.get_formula({
            'fml_name': fml_name,
            'svn_branch': svn_branch
        })

    @json_response
    def check_formula(self, fml_name, svn_branch):
        return self.server.check_formula({
            'fml_name': fml_name,
            'svn_branch': svn_branch
        })

    @json_response
    def get_prod_path(self, vertical, ui, tld, svn_branch):
        return self.server.get_prod_path({
            'vertical': vertical,
            'ui': ui,
            'tld': tld,
            'svn_branch': svn_branch
        })

    @json_response
    def get_formulas(self, svn_branch, rd_directory=None):
        return self.server.get_formulas({
            'svn_branch': svn_branch,
            'rd_directory': rd_directory
        })

    @json_response
    def get_branch_info(self, svn_branch):
        return self.server.get_branch_info({
            'svn_branch': svn_branch
        })
