# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import parameters as sp


class DateParameter(sp.SandboxStringParameter):
    name = 'date'
    description = 'Date to restore blender state (DD/MM/YYYY)'
    default_value = '01/01/2016'


class UserNameParameter(sp.SandboxStringParameter):
    name = 'user_name'
    description = 'User name for svn commit'
    default_value = ''
    required = True


class RearrReeourceId(sp.SandboxStringParameter):
    name = 'rearr_resource_id'
    description = 'Resource Id of rearrange parameters to switch on old formulas'
    default_value = ''
    required = True


class FmlConfigServerHostParameter(sp.SandboxStringParameter):
    name = 'fml_config_server_host'
    description = 'Address of the fml config server'
    default_value = 'http://veles:36201'


class ArcadiaPathParameter(sp.SandboxStringParameter):
    name = 'arcadia_path'
    description = 'svn path to Arcadia'
    default_value = 'arcadia:arc/trunk/arcadia'


class RDSvnPathParameter(sp.SandboxStringParameter):
    name = 'rd_svn_path'
    description = 'svn path to rearrange.dynamic'
    default_value = 'arcadia:arc/trunk/arcadia/search/web/rearrs_upper/rearrange.dynamic/'


class PatchFmlConfigSvnParameter(sp.SandboxStringParameter):
    name = 'patch_fml_config_svn_path'
    description = 'svn path to patch_fml_config'
    default_value = 'arcadia:arc/trunk/arcadia/yweb/blender/scripts/patch_fml_config/'
