import urllib2
from multiprocessing import cpu_count
from multiprocessing.pool import ThreadPool

import time

RETRY_COUNT = 20
RETRY_SLEEP = 20


def fetch(urls, retry_count=RETRY_COUNT, retry_sleep=RETRY_SLEEP):
    """
    :param urls:
    :type urls: iterable
    :return: list of tuples
    :rtype: list
    """

    def read(url):
        ret = None
        for i in range(RETRY_COUNT):
            try:
                return [200, urllib2.urlopen(url).read().decode('utf-8')]
            except urllib2.HTTPError, e:
                ret = [e.code, url]
                time.sleep(RETRY_SLEEP)
            except urllib2.URLError, e:
                ret = [-1, url]
                time.sleep(RETRY_SLEEP)
            except Exception, e:
                ret = [-2, url]
                time.sleep(RETRY_SLEEP)
        return ret

    return ThreadPool(cpu_count()).map(read, urls)
