import requests
from requests.adapters import HTTPAdapter
import logging


STATUS_OK = 'OK'
STATUS_CRIT = 'CRIT'


class JugglerClient(object):
    def __init__(self, enabled, host, prefix=None):
        # type: (bool, str) -> None

        self.enabled = enabled
        self.host = host
        self.session = requests.Session()
        self.prefix = prefix
        for scheme in ('http://', 'https://'):
            self.session.mount(scheme, HTTPAdapter(max_retries=3))

    def ping(self, service, status, description):
        # type: (str, str, str) -> None

        logger = logging.getLogger("juggler")
        prefixed_service = service if not self.prefix else self.prefix + '_' + service

        js = {
            "source": "sandbox",
            "events": [{
                "host": self.host,
                "service": prefixed_service,
                "status": status,
                "description": description
            }]
        }

        if not self.enabled:
            logger.info("Juggler event (not actually sent): %s", repr(js))
            return

        try:
            reply = self.session.post("http://juggler-push.search.yandex.net/events", json=js, timeout=(15.0, 15.0))
            reply.raise_for_status()
            event_status = reply.json()["events"][0]
            if event_status["code"] != 200:
                raise Exception(event_status["error"])
        except Exception:
            logger.exception("unable to send Juggler check")
