import hashlib
import logging

import requests


class MdsUploadError(Exception):
    pass


class Mds(object):
    def __init__(self, namespace, size='orig', is_test=True):
        self.session = requests.Session()
        adapter = requests.adapters.HTTPAdapter(pool_connections=100, pool_maxsize=100)
        self.session.mount('http://', adapter)
        self.session.mount('https://', adapter)
        self.session.headers.update({'Connection': 'Keep-Alive'})
        self.namespace = namespace
        self.size = size
        self.get_url = '//avatars.mdst.yandex.net' if is_test else '//avatars.mds.yandex.net'
        self.put_url = 'http://avatars-int.mdst.yandex.net:13000/put-{}/{}' if is_test else 'http://avatars-int.mds.yandex.net:13000/put-{}/{}'

    def upload(self, url):
        url_hash = hashlib.md5(url).hexdigest()
        try:
            http_address = self.put_url.format(self.namespace, url_hash)
            logging.info(http_address + '?url=' + url)
            r = self.session.get(http_address, params={'url': url}, timeout=15, stream=False)
        except requests.RequestException as e:
            raise MdsUploadError(e.message)
        response = r.json()
        if r.status_code == 403:
            return self.get_url + '/get-{}/{}/{}/{}'.format(self.namespace, response['attrs']['group-id'], url_hash,
                                                            self.size)

        try:
            r.raise_for_status()
        except requests.HTTPError:
            raise MdsUploadError(r.content)

        return self.get_url + response['sizes'][self.size]['path']
