import codecs
import os
import tempfile

from sandbox.projects.common.bno.utils import is_iter, is_dict
from sandbox.projects.resource_types import PLAIN_TEXT


def save_resource(task, data=None, path=None, resource_type=PLAIN_TEXT):
    if data is not None:
        path = path or tempfile.mktemp(dir=task.path())
        with codecs.open(path, 'w', encoding='utf-8') as f:
            if is_dict(data):
                for key, val in data.iteritems():
                    f.write(key)
                    f.write('\t')
                    if is_iter(val):
                        val = '\t'.join(map(unicode, val))
                    f.write(val)
                    f.write('\n')
            elif is_iter(data):
                for item in data:
                    if is_iter(item):
                        item = '\t'.join(map(unicode, item))
                    f.write(item)
                    f.write('\n')
            else:
                f.write(data)
    if path and os.path.exists(path):
        resource = task.create_resource(os.path.basename(path), os.path.basename(path), resource_type)
        task.mark_resource_ready(resource)
        return resource
    raise ValueError("path or data is required")
