import os
import logging

from sandbox.projects.common import apihelpers
from sandbox.projects import resource_types
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk import process


def dump_symbols(binary_resource):
    """
        :param binary_resource: Sandbox resource with binary to dump symbols from
    """
    # this code is experimental (for SEARCH-1079) and may fail
    try:
        task = channel.task
        symbols_resource_type = 'SYM_{}'.format(binary_resource.type)
        symbols_resources_ready = channel.sandbox.list_resources(
            resource_type=symbols_resource_type,
            task_id=task.id,
            status='READY',
        )
        if symbols_resources_ready:
            logging.info("We already have at least one %s: resource:%s", symbols_resource_type, symbols_resources_ready[0].id)
            return

        symbols_dumper_res = apihelpers.get_last_released_resource(resource_types.BREAKPAD_SYMBOLS_DUMPER)
        if symbols_dumper_res is None:
            raise Exception("There is no stable BREAKPAD_SYMBOLS_DUMPER for your system")
        symbols_dumper = task.sync_resource(symbols_dumper_res.id)
        binary_basename = os.path.basename(binary_resource.path)
        symbols_name = binary_basename + '.sym'

        dumper_args = [
            symbols_dumper,
            binary_resource.path,
        ]

        symbols_resources_not_ready = channel.sandbox.list_resources(
            resource_type=symbols_resource_type,
            task_id=task.id,
            status='NOT_READY',
        )

        if symbols_resources_not_ready:
            symbols_res = channel.sandbox.get_resource(symbols_resources_not_ready[0])
            symbols_name = symbols_res.path
        else:
            symbols_res = task.create_resource(
                "Symbols for {} [{}] from task {}".format(
                    binary_resource.type,
                    binary_basename,
                    task.descr,
                ),
                resource_path=symbols_name,
                resource_type=symbols_resource_type,
                arch='linux',
            )

        with open(symbols_name, 'w') as symbols_file:
            process.run_process(
                dumper_args,
                outputs_to_one_file=False,
                stdout=symbols_file,
            )
        task.mark_resource_ready(symbols_res)

        if False:
            # TODO(mvel): REMOVE it (see SEARCH-2722)
            signature_name = binary_basename + '.sig'
            # signature_resource_type = 'SIG_{}'.format(binary_resource.type)
            with open(signature_name, 'w') as signature_file:
                process.run_process(
                    'head -n1 ' + symbols_name + ' | cut -d" " -f 4',
                    shell=True,
                    outputs_to_one_file=False,
                    stdout=signature_file,
                )

            signature_res = task.create_resource(
                "Signature for {} [{}] from task {}".format(
                    binary_resource.type,
                    binary_basename,
                    task.descr,
                ),
                resource_path=signature_name,
                resource_type=resource_types.OTHER_RESOURCE,
                arch='linux',
            )
            task.mark_resource_ready(signature_res)

    except Exception as err:
        logging.error("Failed to generate breakpad symbold: %s", err)
