import os
import platform
import tarfile

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.build.BuildForAllTask import DoNotRemoveResourcesParameter
import sandbox.projects.common.constants as consts
import sandbox.sdk2 as sdk2


class ArcadiaProjectResourceType(sdk2.parameters.String):
    name = 'resource_type'
    description = 'Created package resource type'
    required = True
    default_value = resource_types.ARCADIA_PROJECT_TGZ.name


class BuildArcadiaProjectForAllSubtask(CommonBuildTask):
    type = 'BUILD_ARCADIA_PROJECT_FOR_ALL_SUBTASK'

    input_parameters = [ArcadiaProjectResourceType] + CommonBuildTask.input_parameters

    def _target_enabled(self, target):
        return True

    def do_execute(self):
        target = self.ctx.get('build_target')
        self.TARGET_RESOURCES = [
            (resource_types.ARCADIA_PROJECT_BINARY, target)
        ]
        self.prepare_resources()
        target_dir, target_name = os.path.split(self.get_target_resources()[0][1])

        self.ctx[consts.BUILD_SYSTEM_KEY] = consts.YMAKE_BUILD_SYSTEM
        CommonBuildTask.do_execute(self)

        target_platform = self.ctx.get('target_platform_alias', platform.platform())
        attrs = {'platform': target_platform}
        if self.ctx.get(DoNotRemoveResourcesParameter.name):
            attrs['ttl'] = 'inf'

        tgz_resource_name = '{}.tgz'.format(target_name)
        with tarfile.open(self.abs_path(tgz_resource_name), 'w:gz') as tar:
            tar.add(os.path.join(self.LOCAL_BIN_DIR, target_name), arcname=target_name)

        self.create_resource(
            description='{} for {}'.format(target_name, target_platform),
            resource_path=self.abs_path(tgz_resource_name),
            resource_type=self.resource_type,
            attributes=attrs
        )

    @property
    def resource_type(self):
        return sdk2.resource.Resource[self.ctx[ArcadiaProjectResourceType.name]]
