# -*- coding: utf-8 -*-
from sandbox.projects.common.build.YaMake2 import YaMake2
from sandbox.projects.common import task_env
import sandbox.projects.common.build.parameters as build_parameters
import sandbox.projects.common.constants as consts
import sandbox.projects.common.nanny.nanny as nanny


class KosherYaMake(YaMake2, nanny.ReleaseToNannyTask2):
    """
        Классический YaMake2 c переопределенными значениями параметров
        для максимально быстрой работы большинства клиентов.
    """
    class Requirements(task_env.BuildLinuxRequirements):
        pass

    class Parameters(YaMake2.Parameters):
        use_aapi_fuse = build_parameters.UseArcadiaApiFuse(default_value=True)
        use_arc_instead_of_aapi = build_parameters.UseArcInsteadOfArcadiaApi(default_value=False)
        aapi_fallback = build_parameters.AllowArcadiaApiFallback(default_value=True)
        build_system = build_parameters.BuildSystem(default_value=consts.SEMI_DISTBUILD_BUILD_SYSTEM)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        YaMake2.on_release(self, additional_parameters)
