# -*- coding: utf-8 -*-
from sandbox.projects.common import task_env
from sandbox.projects.common.build.YaPackage2 import YaPackage2
import sandbox.projects.common.build.parameters as build_parameters
import sandbox.projects.common.constants as consts


class KosherYaPackage(YaPackage2):
    """
        Классический YaPackage2 c переопределенными значениями параметров
        для максимально быстрой работы большинства клиентов.

        По всем вопросам поддержки данной задачи просьба
        обращаться в Release Machine Support ( https://t.me/joinchat/AAAAAEN49wUGP2uImQ6Dfw )
    """
    class Requirements(task_env.BuildLinuxRequirements):
        pass

    class Parameters(YaPackage2.Parameters):
        use_aapi_fuse = build_parameters.UseArcadiaApiFuse(default_value=True)
        use_arc_instead_of_aapi = build_parameters.UseArcInsteadOfArcadiaApi(default_value=False)
        aapi_fallback = build_parameters.AllowArcadiaApiFallback(default_value=True)
        build_system = build_parameters.BuildSystem(default_value=consts.SEMI_DISTBUILD_BUILD_SYSTEM)
