# coding: utf-8

import sandbox.sandboxsdk.parameters as sb_params

from sandbox.projects import resource_types
import sandbox.projects.common.build.BuildForAllTask as bfa
import sandbox.projects.common.build.ScriptBuildTask as sbt


class SubtaskExecutionSpace(sb_params.SandboxIntegerParameter):
    name = 'subtask_execution_space'
    description = 'Subtask execution space in Gb'
    default_value = 10


class ScriptBuildForAll(bfa.BuildForAllTask):
    type = 'SCRIPT_BUILD_FOR_ALL'
    input_parameters = list(sbt.ScriptBuildTask.input_parameters) + [bfa.PlatformsListParameter, bfa.LinuxPlatformParameter, SubtaskExecutionSpace]
    release_to = 'sandbox-releases@yandex-team.ru'

    def get_resource_description(self):
        if self.resource_description is None:
            self.resource_description = '{} {} for {}'.format(
                self.ctx.get(sbt.ToolNameParameter.name, ''),
                '{version}',
                '{target}'
            )
        return self.resource_description

    def get_subtask_description(self):
        if self.subtask_description is None:
            self.subtask_description = 'Building {} {} for {}'.format(
                self.ctx.get(sbt.ToolNameParameter.name, ''),
                '{version}',
                '{target}'
            )
        return self.subtask_description

    def get_subtask_execution_space(self):
        return self.ctx.get(SubtaskExecutionSpace.name) * 1024

    # BuildForAllTask fields
    subtask_type = sbt.ScriptBuildTask
    resource_type = resource_types.SCRIPT_BUILD_RESULT
