# -*- coding: utf-8 -*-

import logging
import os
import six

import sandbox.sandboxsdk.process as process

from sandbox.projects.common.build.YaExec import YaExec, ArgsParam, ProgramParam, PostScriptParam, TaskResourceParam
import sandbox.projects.common.arcadia.sdk as arcadia_sdk
import sandbox.projects.common.constants as consts
import sandbox.projects.common.utils as utils


class YaExecFuse(YaExec):
    """
        Собрать и запустить пользовательскую программу
        (PROGRAM, PY_PROGRAM, etc.), описанную сборкой ya make
        (с использованием ArcadiaFuse)
    """

    type = "YA_EXEC_FUSE"

    def on_execute(self):
        program_path = utils.get_or_default(self.ctx, ProgramParam)
        post_script = utils.get_or_default(self.ctx, PostScriptParam)
        resource_dir = utils.get_or_default(self.ctx, TaskResourceParam)
        env_vars = self.get_env_vars()

        if program_path:
            build_target = os.path.dirname(program_path)

            build_def_flags = self.get_build_def_flags()

            with arcadia_sdk.mount_arc_path(self.ctx[consts.ARCADIA_URL_KEY]) as arcadia_dir:
                logging.debug("Arcadia src dir %s", arcadia_dir)
                logging.info("Target to build %s", build_target)
                build_return_code = arcadia_sdk.do_build(
                    'ya', arcadia_dir, [build_target],
                    clear_build=False,
                    results_dir=arcadia_dir,
                    def_flags=build_def_flags
                )

                logging.info("Build returned %s", build_return_code)

                process.run_process(
                    [os.path.join(arcadia_dir, program_path), ] + utils.get_or_default(self.ctx, ArgsParam).split(),
                    log_prefix='program',
                    outputs_to_one_file=False,
                    shell=True,
                    work_dir=arcadia_dir,
                    environment=env_vars,
                )

                if resource_dir:
                    self.save_result_dir_as_resource(arcadia_dir, resource_dir)

                if post_script:
                    post_script = "import os; os.chdir('{}'); {}".format(arcadia_dir, post_script)
                    logging.info('Script to execute: %s', post_script)
                    six.exec_(post_script, globals(), locals())

        elif post_script:
            logging.info('Script to execute: %s', post_script)
            six.exec_(post_script, globals(), locals())


__Task__ = YaExecFuse
