# -*- coding: utf-8 -*-
import sandbox.sdk2 as sdk2
from sandbox.sandboxsdk import channel
from sandbox.sandboxsdk import errors
from sandbox.sandboxsdk import svn


def get_arcadia_project_base_target_params(group_name='Arcadia project target parameters:'):
    class Params:
        class TargetsParameter(sdk2.parameters.String):
            name = 'targets'
            description = 'Targets (semicolon separated)'
            required = True
            group = group_name

        params = [TargetsParameter]

    return Params


def validate_arcadia_project(resource_id):
    resource = channel.channel.sandbox.get_resource(resource_id)
    for attr in ('build_platform', 'arcadia_revision'):
        if attr not in resource.attributes:
            return False
    deprecated = False
    for attr in ('build_tool', 'arcadia_trunk', 'arcadia_branch', 'arcadia_tag'):
        if attr not in resource.attributes:
            deprecated = True
            break
    if deprecated and 'arcadia_path' not in resource.attributes:
        return False
    return True


def get_arcadia_project_svn_url(resource_id):
    if not validate_arcadia_project(resource_id):
        raise errors.SandboxTaskFailureError('Invalid Arcadia Project resource: %s' % resource_id)
    resource = channel.channel.sandbox.get_resource(resource_id)
    revision = resource.attributes.get('arcadia_revision')
    url = svn.Arcadia.ARCADIA_BASE_URL

    if 'arcadia_path' in resource.attributes:
        return svn.Arcadia.replace(url, path=resource.attributes.get('arcadia_path'), revision=revision)

    if resource.attributes.get('arcadia_trunk') == 'True':
        return svn.Arcadia.trunk_url(revision=revision)

    arcadia_branch = resource.attributes.get('arcadia_branch')
    if arcadia_branch and arcadia_branch != 'None':
        return svn.Arcadia.branch_url(resource.attributes.get('arcadia_branch'), revision=revision)

    arcadia_tag = resource.attributes.get('arcadia_tag')
    if arcadia_tag and arcadia_tag != 'None':
        return svn.Arcadia.tag_url(resource.attributes.get('arcadia_tag'), revision=revision)

    raise errors.SandboxTaskFailureError('Cannot determine Arcadia Project SVN URL')
